/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_upload_large.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.uploadlarge.dbo;

import java.io.Serializable;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.annotation.AnNew;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.orm.annotation.*;

/**
 * 大文件上传文件表 对应表《UPLL_FILE$ID$》
 */
@AnAlias("UpllFile")
@AnNew
@AnTable(table="UPLL_FILE$ID$", key="FILE_ID", type="InnoDB")
@AnIndex({@AnIndexValue(name="IX_UPLL_FILE$ID$_MD5", column="FILE_MD5", unique=false)})
public class UpllFile implements Serializable
{
    private static final long serialVersionUID = 1L;

    @AnTableReplace("ID")    private String id;
    @AnTableField(column="FILE_ID", type="string,32,char", notNull=true)    private String fileId;    //1.文件编号，一次上传一条记录
    @AnTableField(column="FILE_MD5", type="string,48,char", notNull=true)    private String fileMd5;    //2.文件MD5，消息摘要唯一性，对应URL的文件名，两条记录MD5的文件只保留一份URL和文件
    @AnTableField(column="FILE_NAME", type="string,512", notNull=true)    private String fileName;    //3.文件名称，由用户指定的文件名，对应下载的文件名
    @AnTableField(column="FILE_EXT", type="string,10", notNull=true)    private String fileExt;    //4.文件扩展名
    @AnTableField(column="FILE_LENGTH", type="long", notNull=true)    private long fileLength;    //5.文件长度
    @AnTableField(column="FILE_PATH", type="string,200", notNull=true)    private String filePath;    //6.文件路径，保存到硬盘的绝对路径
    @AnTableField(column="FILE_URL", type="string,200", notNull=true)    private String fileUrl;    //7.文件URL，通过文件目录和指定的域名前缀生成
    @AnTableField(column="FILE_TIME", type="string,19,char", notNull=true)    private String fileTime;    //8.文件上传成功时间
    @AnTableField(column="CONTENT_TYPE", type="string,100", notNull=false)    private String contentType;    //9.内容类型消息头
    @AnTableField(column="CONTENT_ENCODING", type="string,20", notNull=false)    private String contentEncoding;    //10.内容编码消息头
    @AnTableField(column="CACHE_CONTROL", type="string,50", notNull=false)    private String cacheControl;    //11.缓存消息头，no-store,max-age在这里面配置

    public String toString()
    {
        return Jsons.toString(this);
    }

    public String getFileId()
    {
        return fileId;
    }

    public void setFileId(String fileId)
    {
        this.fileId = fileId;
    }

    public String getFileMd5()
    {
        return fileMd5;
    }

    public void setFileMd5(String fileMd5)
    {
        this.fileMd5 = fileMd5;
    }

    public String getFileName()
    {
        return fileName;
    }

    public void setFileName(String fileName)
    {
        this.fileName = fileName;
    }

    public String getFileExt()
    {
        return fileExt;
    }

    public void setFileExt(String fileExt)
    {
        this.fileExt = fileExt;
    }

    public long getFileLength()
    {
        return fileLength;
    }

    public void setFileLength(long fileLength)
    {
        this.fileLength = fileLength;
    }

    public String getFilePath()
    {
        return filePath;
    }

    public void setFilePath(String filePath)
    {
        this.filePath = filePath;
    }

    public String getFileUrl()
    {
        return fileUrl;
    }

    public void setFileUrl(String fileUrl)
    {
        this.fileUrl = fileUrl;
    }

    public String getFileTime()
    {
        return fileTime;
    }

    public void setFileTime(String fileTime)
    {
        this.fileTime = fileTime;
    }

    public String getContentType()
    {
        return contentType;
    }

    public void setContentType(String contentType)
    {
        this.contentType = contentType;
    }

    public String getContentEncoding()
    {
        return contentEncoding;
    }

    public void setContentEncoding(String contentEncoding)
    {
        this.contentEncoding = contentEncoding;
    }

    public String getCacheControl()
    {
        return cacheControl;
    }

    public void setCacheControl(String cacheControl)
    {
        this.cacheControl = cacheControl;
    }

    public String getId()
    {
        return id;
    }

    public int getIdInt()
    {
        return Integer.parseInt(id);
    }

    public long getIdLong()
    {
        return Long.parseLong(id);
    }

    public void setId(String id)
    {
        this.id = id;
    }

    public void setIdInt(int id)
    {
        this.id = String.valueOf(id);
    }

    public void setIdLong(long id)
    {
        this.id = String.valueOf(id);
    }

}
