/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_upload_large.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.uploadlarge.dbo;

import java.io.Serializable;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.annotation.AnNew;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.orm.annotation.*;

/**
 * 大文件上传分块表 对应表《UPLL_CHUNK$ID$》
 */
@AnAlias("UpllChunk")
@AnNew
@AnTable(table="UPLL_CHUNK$ID$", key="FILE_MD5,CHUNK_SIZE", type="InnoDB")
public class UpllChunk implements Serializable
{
    private static final long serialVersionUID = 1L;

    @AnTableReplace("ID")    private String id;
    @AnTableField(column="FILE_MD5", type="string,48,char", notNull=true)    private String fileMd5;    //1.文件MD5，文件消息摘要，检查文件唯一性
    @AnTableField(column="CHUNK_SIZE", type="int,11", notNull=true)    private int chunkSize;    //2.文件分块大小，当文件MD5相同且分块相同时，认为是同一文件
    @AnTableField(column="CHUNK_NUM", type="int,11", notNull=true)    private int chunkNum;    //3.文件总分块数
    @AnTableField(column="CHUNK_NO", type="int,11", notNull=true)    private int chunkNo;    //4.文件已上传分块数
    @AnTableField(column="CHUNK_TIME", type="string,19,char", notNull=true)    private String chunkTime;    //5.文件分块第一次上传时间
    @AnTableField(column="FILE_NAME", type="string,512", notNull=true)    private String fileName;    //6.文件名称，由用户指定的文件名，对应下载的文件名
    @AnTableField(column="FILE_EXT", type="string,10", notNull=true)    private String fileExt;    //7.文件扩展名
    @AnTableField(column="FILE_PATH", type="string,200", notNull=true)    private String filePath;    //8.文件路径，保存到硬盘的绝对路径

    public String toString()
    {
        return Jsons.toString(this);
    }

    public String getFileMd5()
    {
        return fileMd5;
    }

    public void setFileMd5(String fileMd5)
    {
        this.fileMd5 = fileMd5;
    }

    public int getChunkSize()
    {
        return chunkSize;
    }

    public void setChunkSize(int chunkSize)
    {
        this.chunkSize = chunkSize;
    }

    public int getChunkNum()
    {
        return chunkNum;
    }

    public void setChunkNum(int chunkNum)
    {
        this.chunkNum = chunkNum;
    }

    public int getChunkNo()
    {
        return chunkNo;
    }

    public void setChunkNo(int chunkNo)
    {
        this.chunkNo = chunkNo;
    }

    public String getChunkTime()
    {
        return chunkTime;
    }

    public void setChunkTime(String chunkTime)
    {
        this.chunkTime = chunkTime;
    }

    public String getFileName()
    {
        return fileName;
    }

    public void setFileName(String fileName)
    {
        this.fileName = fileName;
    }

    public String getFileExt()
    {
        return fileExt;
    }

    public void setFileExt(String fileExt)
    {
        this.fileExt = fileExt;
    }

    public String getFilePath()
    {
        return filePath;
    }

    public void setFilePath(String filePath)
    {
        this.filePath = filePath;
    }

    public String getId()
    {
        return id;
    }

    public int getIdInt()
    {
        return Integer.parseInt(id);
    }

    public long getIdLong()
    {
        return Long.parseLong(id);
    }

    public void setId(String id)
    {
        this.id = id;
    }

    public void setIdInt(int id)
    {
        this.id = String.valueOf(id);
    }

    public void setIdLong(long id)
    {
        this.id = String.valueOf(id);
    }

}
