/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_upload_large.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.uploadlarge.action;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.core.Action;
import org.zhiqim.kernel.util.Files;
import org.zhiqim.kernel.util.Ints;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.orm.ORM;
import org.zhiqim.orm.dbo.Selector;
import org.zhiqim.uploadlarge.ZulBootstrap;
import org.zhiqim.uploadlarge.dbo.UpllChunk;

/**
 * 删除文件碎片功能
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class FileChunkDeleteAction implements Action
{
    public void execute(HttpRequest request) throws Exception
    {
        String fileId = request.getParameter("fileId");
        if (Validates.isEmpty(fileId) || fileId.indexOf(",") == -1)
        {
            request.returnHistory("请选择一个有效的数据");
            return;
        }
        
        int ind = fileId.indexOf(",");
        String fileMd5 = fileId.substring(0, ind);
        int chunkSize = Ints.toInt(fileId.substring(ind+1), -1);
        if (!Validates.isAlphaNumericLen(fileMd5, 32, 32) || chunkSize == -1)
        {
            request.returnHistory("请选择一个有效的数据");
            return;
        }
        
        //选删除文件，再删除数据库数据
        Selector selector = new Selector();
        selector.addReplace("id", request.getNestAttributeString(ORM.Z_ORM_ID));
        selector.addMust("fileMd5", fileMd5);
        selector.addMust("chunkSize", chunkSize);
        UpllChunk chunk = ZulBootstrap.table(request).item(UpllChunk.class, selector);
        
        Files.deleteFile(chunk.getFilePath());
        
        ZulBootstrap.table(request).delete(UpllChunk.class, selector);
    }
}
