/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙标记语言（zhiqim_zml）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_zml.htm
 *
 * This file is part of [zhiqim_zml].
 * 
 * [zhiqim_zml] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_zml] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_zml].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.zml.expression.operator;

import org.zhiqim.zml.Expression;
import org.zhiqim.zml.ZmlVariable;
import org.zhiqim.zml.exception.ExpressionException;
import org.zhiqim.zml.expression.Operator;
import org.zhiqim.zml.expression.primitive._Decimal;
import org.zhiqim.zml.expression.primitive._Integer;

/**
 * 取负运算(-)
 * 
 * @see _Subtraction 和减号 运算符相同，要注意区分
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class _Negative extends Operator
{
    private final Expression obj;
    
    public _Negative(Expression obj)
    {
        this.obj = obj;
    }
    
    @Override
    public int getType()
    {
        return NEGATIVE;
    }
    
    @Override
    public Object build(ZmlVariable variableMap) throws ExpressionException
    {
        Object value = obj.build(variableMap);
        if (value instanceof Long)
        {
            long v = (Long)value;
            return -v;
        }
        else if (value instanceof Double)
        {
            double v = (Double)value;
            return -v;
        }
        
        throw new ExpressionException("取负表达式{"+this+"}格式不正常，要求结果不是整数或小数");
    }
    
    @Override
    public String toString()
    {
        return new StringBuilder("-").append(obj).toString() ;
    }
    
    public Number getValue() throws ExpressionException
    {
        if (obj instanceof _Integer)
        {
            _Integer value = (_Integer)obj;
            return -value.getLong();
        }
        else if (obj instanceof _Decimal)
        {
            _Decimal value = (_Decimal)obj;
            return -value.getDouble();
        }
        else if (obj instanceof _Bracket)
        {
            Expression expression = ((_Bracket)obj).getExpression();
            if (expression instanceof _Integer)
            {
                _Integer value = (_Integer)obj;
                return -value.getLong();
            }
            else if (expression instanceof _Decimal)
            {
                _Decimal value = (_Decimal)obj;
                return -value.getDouble();
            }
        }
        
        throw new ExpressionException("[逻辑取负运算符]解析时异常，对象不是数值型["+obj+"]");
    }
}
