/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙标记语言（zhiqim_zml）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_zml.htm
 *
 * This file is part of [zhiqim_zml].
 * 
 * [zhiqim_zml] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_zml] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_zml].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.zml.expression.operator;

import org.zhiqim.kernel.util.Types;
import org.zhiqim.zml.Expression;
import org.zhiqim.zml.ZmlVariable;
import org.zhiqim.zml.exception.ExpressionException;
import org.zhiqim.zml.expression.Operator;

/**
 * 除法运算(/)
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class _Division extends Operator
{
    private final Expression left;
    private final Expression right;
    
    public _Division(Expression left, Expression right)
    {
        this.left = left;
        this.right = right;
    }
    
    @Override
    public int getType()
    {
        return DIVISION;
    }
    
    @Override
    public Object build(ZmlVariable variableMap) throws ExpressionException
    {
        Object privous = left.build(variableMap);
        Object next = right.build(variableMap);
        
        if (!Types.isNumber(privous) || !Types.isNumber(next))
        {//不是整数和小数
            throw new ExpressionException("除法表达式{"+this+"}，格式不正确，除数或被除数不是数值型");
        }
        
        Number dividend = (Number)privous;
        Number divisor = (Number)next;
        
        if (Types.isInteger(privous))
        {//整数
            if (Types.isInteger(next))
                return dividend.longValue() / divisor.longValue();
            else
                return dividend.longValue() / divisor.doubleValue();
        }
        else
        {//小数
            if (Types.isInteger(next))
                return dividend.doubleValue() / divisor.longValue();
            else
                return dividend.doubleValue() / divisor.doubleValue();
        }
    }
    
    @Override
    public String toString()
    {
        return new StringBuilder().append(left).append(" / ").append(right).toString() ;
    }
}
