/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙数据库映射（zhiqim_orm）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_orm.htm
 *
 * This file is part of [zhiqim_orm].
 * 
 * [zhiqim_orm] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_orm] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_orm].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.orm.executor;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.LinkedList;

import org.zhiqim.kernel.extend.MapSS;
import org.zhiqim.kernel.extend.SO;
import org.zhiqim.kernel.util.Sqls;
import org.zhiqim.orm.ORMException;
import org.zhiqim.orm.ORMServer;
import org.zhiqim.orm.datasource.ZDBClose;
import org.zhiqim.orm.datasource.ZStatement;
import org.zhiqim.orm.dbo.Dbo;

/**
 * 查询处理器接口，参数为Class类型[com.zhiqim.dbo.User]
 * 
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class UpdateExecutorClass implements UpdateExecutor
{
    /**
     * 执行executeUpdate处理，全部为通配符匹配
     * 
     * @param server        ORM服务
     * @param conn          数据库连接
     * @param sql           ZSQL语句
     * @param param         参数
     * @param replaceMap    可替换表
     * @return              返回int，处理条数
     * @throws ORMException 映射异常
     * @throws SQLException 数据映射异常
     */
    public int execute(ORMServer server, Connection conn, String sql, Object param, MapSS replaceMap) throws ORMException, SQLException
    {
        PreparedStatement pstmt = null;
        String str = null;

        try
        {
            // 1.替换可替换符$$
            sql = Sqls.formatReplaceMap(sql, replaceMap);

            // 2.获取通配符##
            Dbo dbo = server.getDbo(param.getClass().getName());
            LinkedList<SO> paramKeyList = new LinkedList<>();
            for (int i = 0, start = 0, end = sql.indexOf('#'); end != -1; i++, start = end, end = sql.indexOf('#', start + 1))
            {
                if (i % 2 == 0)
                    continue;
                String paramKey = sql.substring(start + 1, end);// 取出KEY,支持类field和表column
                String method = dbo.getGetMethod(paramKey);
                if (method == null)
                    throw new ORMException("_Table/_View/_Dbo[" + dbo.getClass().getName() + "]没有找到" + paramKey + "对应的方法]");

                // 反射机制取值
                Method m = param.getClass().getMethod(method, new Class[0]);
                Object value = m.invoke(param, new Object[0]);
                paramKeyList.add(new SO(paramKey, value));
            }

            for (int i = 0; i < paramKeyList.size(); i++)
            {
                String paramKey = paramKeyList.get(i).key();
                sql = sql.replaceAll("#" + paramKey + "#", "?");// 把#paramKey#换成?
            }

            // 3.SQL语句处理完毕，保留一个打印SQL
            if (server.isUpdateSqlLog())
                str = sql;

            // 4.设置传递参数
            pstmt = conn.prepareStatement(sql);
            for (int i = 0; i < paramKeyList.size(); i++)
            {
                Object value = paramKeyList.get(i).value();
                if (server.isUpdateSqlLog())
                    str = ZStatement.setParameter(server, pstmt, i + 1, value, str);
                else
                    ZStatement.setParameter(server, pstmt, i + 1, value);
            }

            // 5.执行处理
            int result = pstmt.executeUpdate();

            // 6.打印日志
            if (server.isUpdateSqlLog())
            {
                str = str.replaceAll("-%6-%-3%-", "?");
                uSqlLog.info(str);
            }

            return result;
        }
        catch (SQLException e)
        {
            log.error("UpdateExecutorClass[SQLException][%s][sql=%s]", e, e.getMessage(), sql);
            throw e;
        }
        catch (Exception e)
        {
            log.error("UpdateExecutorClass[Exception][%s]", e, e.getMessage());
            throw new ORMException(e.getMessage(), e);
        }
        finally
        {
            ZDBClose.close(pstmt);
        }
    }
}
