/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙数据库映射（zhiqim_orm）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_orm.htm
 *
 * This file is part of [zhiqim_orm].
 * 
 * [zhiqim_orm] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_orm] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_orm].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.orm.executor;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

import org.zhiqim.kernel.extend.MapSS;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.orm.ORMConstants;
import org.zhiqim.orm.ORMException;
import org.zhiqim.orm.ORMServer;

/**
 * 查询处理器接口，传递OMR服务，连接，query，参数和可替换表等
 * 
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public interface QueryExecutor extends ORMConstants
{
    public final Log log = LogFactory.getLog(QueryExecutor.class);
    public final Log uSqlLog = LogFactory.getLog("update.sql.log");
    public final Log qSqlLog = LogFactory.getLog("query.sql.log");

    /**
     * 执行executeQuery处理
     * 
     * @param server        ORM服务
     * @param conn          数据库连接
     * @param sql           ZSQL语句
     * @param param         参数
     * @param replaceMap    可替换表
     * @return              返回结果集列表
     * @throws ORMException 映射异常
     * @throws SQLException 数据映射异常
     */
    public List<?> execute(ORMServer server, Connection conn, String sql, Class<?> resultClass, Object param, MapSS replaceMap) throws ORMException, SQLException;

}
