/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙数据库映射（zhiqim_orm）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_orm.htm
 *
 * This file is part of [zhiqim_orm].
 * 
 * [zhiqim_orm] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_orm] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_orm].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.orm.dbo.condition;

import org.zhiqim.kernel.util.Classes;
import org.zhiqim.orm.dbo.Comparator;


/**
 * 大于等于条件
 *
 * @see _Compare    具体实现在父类比较条件中
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class _ThenGE extends _Compare
{
    public _ThenGE(String field, Object value)
    {
        super(field, value, THEN_GE);
    }
    
    public boolean match(Object obj)
    {
        Object fValue = Classes.getFieldValue(obj, field);
        return Comparator.compareValue(fValue, value) >= 0;
    }
}
