/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙数据库映射（zhiqim_orm）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_orm.htm
 *
 * This file is part of [zhiqim_orm].
 * 
 * [zhiqim_orm] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_orm] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_orm].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.orm.dbo.condition;

import java.util.ArrayList;
import java.util.List;

import org.zhiqim.kernel.extend.MapSO;
import org.zhiqim.orm.ORMException;
import org.zhiqim.orm.dbo.Condition;
import org.zhiqim.orm.dbo.Dbo;

/**
 * 或者条件，里面是一个条件列表，格式如：(field = 'abc' or field2 <> 'def')
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class _Or extends Condition
{
    List<Condition> list = new ArrayList<Condition>(2);
    
    public void addCondition(Condition condition)
    {
        list.add(condition);
    }
    
    public boolean match(Object obj)
    {
        for (Condition c : list)
        {
            if (c.match(obj))
                return true;
        }
        
        return false;
    }
    
    public String toSql(Dbo dbo, MapSO paramMap) throws ORMException
    {
        if (list.size() < 2)
            throw new ORMException("ZTable/ZView[or]要求的条件数目必须>=2个");
        
        StringBuilder strb = new StringBuilder("(");
        //第一个
        strb.append(list.get(0).toSql(dbo, paramMap));
        //后面的
        for (int i=1;i<list.size();i++)
        {
            strb.append(_SPACE_).append(OR).append(_SPACE_)
                .append(list.get(i).toSql(dbo, paramMap));
        }
        strb.append(")");
        
        return strb.toString();
    }
    
    public List<Condition> getCondition()
    {
        return list;
    }
}
