/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙数据库映射（zhiqim_orm）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_orm.htm
 *
 * This file is part of [zhiqim_orm].
 * 
 * [zhiqim_orm] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_orm] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_orm].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.orm.dbo;

import org.zhiqim.orm.dbo.defined._Dbo;
import org.zhiqim.orm.dbo.defined._Table;
import org.zhiqim.orm.dbo.defined._View;

/**
 * 数据库对象模型，(_Dbo,_Table, _View)三个子类<br><br>
 * @see _Dbo     是查询结果对象，用于executeQuery时组装返回一个对象<br>
 * @see _Table      是数据库表对象，用于ZTable对象映射到数据库进行增删改查<br>
 * @see _View       是数据库视图对象，由多个表数据组装而成，用于ZView关联查询<br>
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public interface Dbo
{
    /** 获取类名 */
    public String getName();
    
    /** 判断是否是有相等的连接条件 */
    public boolean hasEqualJoin();
    
    /** 判断是否存在该字段 */
    public boolean hasField(String fieldName);
    
    /** 通过字段获取数据库列名 */
    public String getColumn(String fieldName);
    
    /** 通过字段名获取组装GET方法 */
    public String getGetMethod(String fieldName);
    
    /** 通过字段名获取字段 */
    public DboField getField(String fieldName);
    
    /** 获取字段列表，按长度排序 */
    public DboField[] getFieldColumnListOrderByLen();
}
