/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙数据库映射（zhiqim_orm）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_orm.htm
 *
 * This file is part of [zhiqim_orm].
 * 
 * [zhiqim_orm] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_orm] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_orm].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.orm.datasource;

import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.sql.Types;

public class ZCall
{
    /**
     * 从存储过程中读取对象
     * 
     * @param resultClass   结果类
     * @param cstmt         过程
     * @param index         索引值
     * @return              索引位置的对象
     * @throws SQLException SQL异常
     */
    public static Object getValue(Class<?> resultClass, CallableStatement cstmt, int index) throws SQLException
    {
        if (resultClass == boolean.class || resultClass == Boolean.class)
            return cstmt.getBoolean(index);
        else if (resultClass == byte.class || resultClass == Byte.class || resultClass == short.class || resultClass == Short.class || resultClass == int.class || resultClass == Integer.class)
            return cstmt.getInt(index);
        else if (resultClass == long.class || resultClass == Long.class)
            return cstmt.getLong(index);
        //日期类型
        else if (resultClass == Timestamp.class)
            return cstmt.getTimestamp(index);
        else if (resultClass == Date.class)
            return cstmt.getDate(index);
        else if (resultClass == Time.class)
            return cstmt.getTime(index);
        //字符串
        else if (resultClass == String.class)
            return cstmt.getString(index);
        //二进制
        else if (resultClass == byte[].class)
            return cstmt.getBytes(index);
        else
        {//其他类型
            return cstmt.getObject(index);
        }
    }
    
    /**
     * 通过类，对应到存储过程的类型
     * 
     * @param clazz         类结构
     * @return              数据库字段类型
     */
    public static int getType(Class<?> clazz)
    {
        if (clazz == null)
            return Types.NULL;
        else if (clazz == boolean.class || clazz == Boolean.class)
            return Types.BOOLEAN;
        else if (clazz == byte.class || clazz == Byte.class || clazz == short.class || clazz == Short.class || clazz == int.class || clazz == Integer.class)
            return Types.INTEGER;
        else if (clazz == long.class || clazz == Long.class)
            return Types.BIGINT;
        //日期类型
        else if (clazz == Timestamp.class)
            return Types.TIMESTAMP;
        else if (clazz == Date.class)
            return Types.DATE;
        else if (clazz == Time.class)
            return Types.TIME;
        //字符串
        else if (clazz == String.class)
            return Types.VARCHAR;
        //二进制
        else if (clazz == byte[].class)
            return Types.BLOB;
        else
        {//其他类型
            return Types.OTHER;
        }
    }
}
