/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙数据库映射（zhiqim_orm）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_orm.htm
 *
 * This file is part of [zhiqim_orm].
 * 
 * [zhiqim_orm] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_orm] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_orm].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.orm.config;

import java.io.IOException;
import java.io.InputStream;

import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import org.zhiqim.kernel.util.Resources;
import org.zhiqim.orm.ORMConstants;

/**
 * 实现DTD本地验证,这样则不要到zhiqim.org下载验证 <br>
 */
public class ZSQLResolver implements EntityResolver, ORMConstants
{
    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException 
    {
        if (Z_SQL_CONFIG_DTD_PUBLIC_ID.equals(publicId))
        {
            InputStream stream = Resources.getResourceStream(ZSQLResolver.class, Z_SQL_CONFIG_DTD_PATH);
            return new InputSource(stream);
        }
        
        return null;
    }
}
