/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙数据库映射（zhiqim_orm）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_orm.htm
 *
 * This file is part of [zhiqim_orm].
 * 
 * [zhiqim_orm] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_orm] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_orm].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.orm;

import org.zhiqim.kernel.constants.CodeConstants;
import org.zhiqim.kernel.constants.SignConstants;
import org.zhiqim.kernel.constants.TypeConstants;
import org.zhiqim.kernel.util.consts.Int;

/**
 * ORM常量定义
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public interface ORMConstants extends SignConstants, TypeConstants, CodeConstants
{
    public enum CALL_TYPE {IN, INOUT, OUT};
    
    /*****************************************************************************/
    //目前支持的6种数据库类型
    /*****************************************************************************/
    
    public String Z_ORM_ID                     = "orm.id";
    
    public Int Z_ORM_MYSQL                     = new Int(1, "mysql");
    public Int Z_ORM_ORACLE                    = new Int(2, "oracle");
    public Int Z_ORM_MSSQL                     = new Int(3, "mssql");
    public Int Z_ORM_PSQL                      = new Int(4, "postgresql");
    public Int Z_ORM_SQLITE                    = new Int(5, "sqlite");
    public Int Z_ORM_HSQL                      = new Int(6, "hsql");
    
    public int Z_ORM_MYSQL_INT                 = 1;
    public int Z_ORM_ORACLE_INT                = 2;
    public int Z_ORM_MSSQL_INT                 = 3;
    public int Z_ORM_PSQL_INT                  = 4;
    public int Z_ORM_SQLITE_INT                = 5;
    public int Z_ORM_HSQL_INT                  = 6;
    
    /*****************************************************************************/
    //目前支持的9种列类型
    /*****************************************************************************/
    
    public Int Z_ORM_STRING                    = new Int(1, "string");
    public Int Z_ORM_INT                       = new Int(2, "int");
    public Int Z_ORM_LONG                      = new Int(3, "long");
    
    public Int Z_ORM_BOOLEAN                   = new Int(4, "boolean");
    public Int Z_ORM_BYTE                      = new Int(5, "byte");
    public Int Z_ORM_SHORT                     = new Int(6, "short");
    
    public Int Z_ORM_DATETIME                  = new Int(7, "datetime");
    public Int Z_ORM_DECIMAL                   = new Int(8, "decimal");
    public Int Z_ORM_BINARY                    = new Int(9, "binary");
    
    public int Z_ORM_STRING_INT                = 1;
    public int Z_ORM_INT_INT                   = 2;
    public int Z_ORM_LONG_INT                  = 3;
    public int Z_ORM_BOOLEAN_INT               = 4;
    public int Z_ORM_BYTE_INT                  = 5;
    public int Z_ORM_SHORT_INT                 = 6;
    public int Z_ORM_DATETIME_INT              = 7;
    public int Z_ORM_DECIMAL_INT               = 8;
    public int Z_ORM_BINARY_INT                = 9;
    
    /*****************************************************************************/
    //zhiqim-sql配置信息
    /*****************************************************************************/
    
    public String Z_SQL_CONFIG_DTD_PUBLIC_ID   = "-//ZHIQIM //DTD Zhiqim-Sql Configuration 1.5.0//EN";
    public String Z_SQL_CONFIG_DTD_PATH        = "/org/zhiqim/orm/config/zhiqim_sql_1_5_0.dtd";
    public String Z_SQL_CONFIG_DTD_URL         = "http://zhiqim.org/xmldtds/zhiqim_sql_1_5_0.dtd";
    
    public String Z_SQL_CONFIG_XML_DOCTYPE     = "<!DOCTYPE ZHIQIM-SQL PUBLIC \"" + Z_SQL_CONFIG_DTD_PUBLIC_ID + "\" \"" + Z_SQL_CONFIG_DTD_URL + "\">";
    
    public String Z_SQL_CONFIG_XML_HEAD        = "<zhiqim-sql>";
    public String Z_SQL_CONFIG_XML_TAIL        = "</zhiqim-sql>";
    
    public String Z_SQL_ENDSWITH               = ".sql.xml";
    
    //zhiqim-sql所在的位置
    public int Z_SQL_FILE_INT                  = 0;
    public int Z_SQL_FOLDER_INT                = 1;
    public int Z_SQL_CLASS_INT                 = 2;
    public int Z_SQL_PACKAGE_INT               = 3;
    
    public String Z_SQL_FILE                   = "file";
    public String Z_SQL_FOLDER                 = "folder";
    public String Z_SQL_CLASS                  = "classpath";
    public String Z_SQL_PACKAGE                = "package";
    
    /*****************************************************************************/
    //SQL条件
    /*****************************************************************************/
    
    public int EQUAL                           = 0;//=             等于
    public int NOT_EQUAL                       = 1;//<>            不等
    public int OR                              = 2;//or            否则
    public int LIKE                            = 10;//'%value%'    两边都LIKE
    public int LIKE_LEFT                       = 11;//'%value'     左LIKE
    public int LIKE_RIGHT                      = 12;//'value%'     右LIKE
    public int THEN_G                          = 21;//>            大于
    public int THEN_GE                         = 22;//>=           大于等于
    public int THEN_L                          = 23;//<            小于
    public int THEN_LE                         = 24;//<=           小于等于
    public int IS_NULL                         = 31;//is null      为空
    public int IS_NOT_NULL                     = 32;//is not null  不为空
    public int IN                              = 33;//in           包含
    public int NOT_IN                          = 34;//not in       不包含
    
    public String ASC                          = "asc";//顺序
    public String DESC                         = "desc";//倒序
    
    public String JOIN_EQUAL                   = "EQUAL";//内连接inner join
    public String JOIN_LEFT                    = "LEFT";//左连接left join
    public String JOIN_RIGHT                   = "RIGHT";//右连接right join
    
    /*****************************************************************************/
    //表是否存在的SQL语句
    /*****************************************************************************/
    
    public String T_EXISTS_MYSQL               = "select count(*) from information_schema.tables where table_schema='%s' and table_name='%s'";
    public String T_EXISTS_ORACLE              = "select count(*) from tab where tabtype='TABLE' and tname='%s'";
    public String T_EXISTS_MSSQL               = "select count(*) from sysobjects where type='U' and name='%s'";
    public String T_EXISTS_PSQL                = "select count(*) from pg_tables where tablename='%s'";
    public String T_EXISTS_SQLITE              = "select count(*) from sqlite_master where type='table' and name='%s'";
    public String T_EXISTS_HSQL                = "select count(*) from information_schema.tables where table_name='%s';";
    
    public String T_COLUMN_MYSQL               = "select COLUMN_TYPE,IS_NULLABLE from information_schema.columns where table_schema=? and table_name=? and column_name=?";
    public String T_SELECT_IDENTITY            = "select @@IDENTITY";
}
