/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd.validate.two;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.httpd.util.Scripts;
import org.zhiqim.httpd.validate.TwoValidate;

/**
 * 验证是否大于等于
 * 
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
@AnAlias("IsGreaterEqualThen")
public class IsGreaterEqualThen extends TwoValidate
{
    private String field2;
    
    public IsGreaterEqualThen(String field1, String field2, String alert)
    {
        super(field1, field2, alert);
    }
    
    public IsGreaterEqualThen(String field1, String field2, String alert, String elementId)
    {
        super(field1, field2, alert, elementId);
        this.field2 = field2;
    }
    
    public IsGreaterEqualThen(String field1, String field2, String alert, boolean isFocus)
    {
        super(field1, field2, alert, false, isFocus);
    }
    
    public IsGreaterEqualThen(String field1, String field2, String alert, boolean isFocus, String elementId)
    {
        super(field1, field2, alert, false, isFocus, elementId);
    }
    
    /** 获取该验证的名称 */
    public String getName()
    {
        return IS_GREATER_EQUAL_THEN;
    }
    
    /** 服务端验证 */
    public boolean validate(String value1, String value2)
    {
        if (value1 == null || value2 == null)
            return false;
        
        return value1.compareTo(value2) >= 0;
    }
    
    /** 获取该验证的函数 */
    public String getFunction()
    {
        return Scripts.isGreaterEqualThen();
    }
    
    /** 获取该验证的判断代码 */
    public String getScript()
    {
        return Scripts.buildValidateScriptTwo(IS_GREATER_EQUAL_THEN, field, field2, alert, elementId, isFocus);
    }

}
