/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd.validate.two;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.httpd.util.Scripts;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.httpd.validate.TwoValidate;

/**
 * 验证两个值是否相等 <br>
 * 
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
@AnAlias("IsEqual")
public class IsEqual extends TwoValidate
{   
    /** 默认构造 */
    public IsEqual(String field1, String field2, String alert)
    {
        super(field1, field2, alert);
    }
    
    /** 构造函数，支持把错误信息传到elementId中 */
    public IsEqual(String field1, String field2, String alert, String elementId)
    {
        super(field1, field2, alert, elementId);
    }
    
    /** 构造函数，支持判断是否允许为空，支持判断是否响应焦点 */
    public IsEqual(String field1, String field2, String alert, boolean isFocus)
    {
        super(field1, field2, alert, false, isFocus);
    }
    
    /** 获取该验证的名称 */
    public String getName()
    {
        return IS_EQUAL;
    }

    /** 服务端验证 */
    public boolean validate(String value, String value2)
    {
        return Validates.isEqual(value, value2);
    }
    
    /** 获取该验证的函数 */
    public String getFunction()
    {
        return Scripts.isEqual();
    }
    
    /** 获取该验证的判断代码 */
    public String getScript()
    {
        StringBuilder strb = new StringBuilder();
        strb.append(_FOUR_).append("if(!").append(IS_EQUAL).append("(form.").append(field).append(".value, form.").append(field2).append(".value))").append(_BR_);
        strb.append(_FOUR_).append("{").append(_BR_);
        if (elementId == null)
            strb.append(_FOUR_).append(_FOUR_).append("alert('").append(alert).append("');").append(_BR_);
        else
            strb.append(_FOUR_).append(_FOUR_).append("document.getElementById(\"").append(elementId).append("\").innerHTML='").append(alert).append("';").append(_BR_);
        if (isFocus)
            strb.append(_FOUR_).append(_FOUR_).append("form.").append(field2).append(".focus();").append(_BR_);
        strb.append(_FOUR_).append(_FOUR_).append("return false;").append(_BR_);
        strb.append(_FOUR_).append("}").append(_BR_).append(_BR_);
        
        return strb.toString();
    }
    
}