/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd.validate.onex;

import org.zhiqim.httpd.util.Scripts;
import org.zhiqim.httpd.validate.OneValidate;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.util.Validatex;

/**
 * 验证是否 邮编
 * 
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
@AnAlias("IsPostalCode")
public class IsPostalCode extends OneValidate
{
    /** 默认构造 */
    public IsPostalCode(String field, String alert)
    {
        super(field, alert);
    }
    
    /** 构造函数，支持把错误信息传到elementId中 */
    public IsPostalCode(String field, String alert, String elementId)
    {
        super(field, alert, elementId);
    }
    
    /** 默认构造，支持判断是否允许为空 */
    public IsPostalCode(String field, String alert, boolean allowEmpty)
    {
        super(field, alert, allowEmpty);
    }
    
    /** 构造函数，支持判断是否允许为空，支持判断是否响应焦点 */
    public IsPostalCode(String field, String alert, boolean allowEmpty, boolean isFocus)
    {
        super(field, alert, allowEmpty, isFocus);
    }
    
    /** 构造函数，支持判断是否允许为空，支持把错误信息传到elementId中 */
    public IsPostalCode(String field, String alert, boolean allowEmpty, String elementId)
    {
        super(field, alert, allowEmpty, elementId);
    }

    /** 获取该验证的名称 */
    public String getName()
    {
        return IS_POSTAL_CODE;
    }

    /** 服务端验证 */
    public boolean validate(String value)
    {
        return Validatex.isPostalCode(value, allowEmpty);
    }
        
    /** 获取该验证的函数 */
    public String getFunction()
    {
        return Scripts.isPostalCode(allowEmpty);
    }

    /** 获取该验证的判断代码 */
    public String getScript()
    {
        return Scripts.buildValidateScript(IS_POSTAL_CODE, field, alert, elementId, isFocus);
    }
}
