/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd.validate.ones;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.httpd.util.Scripts;
import org.zhiqim.httpd.validate.OneValidate;

/**
 * 验证是否 选择了一项或多项<br><br>
 * 
 * 注:不支持空格<br>
 * 
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
@AnAlias("IsSelect")
public class IsSelect extends OneValidate
{
    public IsSelect(String field, String alert)
    {
        super(field, alert, false, false);
    }
    
    public IsSelect(String field, String alert, String elementId)
    {
        super(field, alert, false, elementId);
    }

    /** 获取该验证的名称 */
    public String getName()
    {
        return IS_SELECT;
    }

    /** 服务端验证 */
    public boolean validate(String value)
    {
        String[] values = Arrays.toStringArray(value);
        return values.length > 0;
    }
    
    /** 获取该验证函数 */
    public String getFunction()
    {
        return Scripts.isSelect();
    }

    /** 获取该验证的判断代码 */
    public String getScript()
    {
        return Scripts.buildValidateScriptField(IS_SELECT, field, alert, elementId, isFocus);
    }
}
