/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd.validate.ones;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.httpd.util.Scripts;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.httpd.validate.OneValidate;

/**
 * 验证不能为空<br>
 * 
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
@AnAlias("IsNotEmpty")
public class IsNotEmpty extends OneValidate
{
    public IsNotEmpty(String field, String alert)
    {
        super(field, alert);
    }
    
    public IsNotEmpty(String field, String alert, String elementId)
    {
        super(field, alert, elementId);
    }
    
    public IsNotEmpty(String field, String alert, boolean isFocus)
    {
        super(field, alert, false, isFocus);
    }
   
    /** 获取该验证的名称 */
    public String getName()
    {
        return IS_NOT_EMPTY;
    }
    
    /** 服务端验证 */
    public boolean validate(String value)
    {
        return Validates.isNotEmptyBlank(value);
    }
    
    /** 获取该验证的函数 */
    public String getFunction()
    {
        return Scripts.isNotEmpty();
    }

    /** 获取该验证的判断代码 */
    public String getScript()
    {
        return Scripts.buildValidateScript(IS_NOT_EMPTY, field, alert, elementId, isFocus);
    }
}
