/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd.validate;

import org.zhiqim.kernel.constants.RegexpConstants;
import org.zhiqim.kernel.constants.SignConstants;

/**
 * 验证接口定义，提供基础的属性，实现由子类完成
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public interface Validate extends RegexpConstants, SignConstants
{
    /**
     * 获取验证子类名称
     * 
     * @return String 验证子类名称,如IsEmpty,IsNumeric等
     */
    public String getName();

    /**
     * 获取告警消息
     * 
     * @return String 告警消息
     */
    public String getAlertMsg();
    
    /**
     * 获取组装后的验证Script
     * 
     * @return String 组装后的验证Script
     */
    public String getScript();
    
    /**
     * 获取验证需要的函数
     * 
     * @return String 验证需要的函数
     */
    public String getFunction();
}
