/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd.validate;

/**
 * 双字段的验证抽象类
 *
 * @version v1.0.0 @author zouzhigang 2016-7-20 新建与整理
 */
public abstract class TwoValidate implements Validate
{
    protected String field;
    protected String field2;
    protected String alert;
    protected boolean allowEmpty;
    protected String elementId;
    protected boolean isFocus;
    
    public TwoValidate(String field, String field2, String alert)
    {
        this(field, field2, alert, false, true);
    }
    
    public TwoValidate(String field, String field2, String alert, String elementId)
    {
        this(field, field2, alert, false, elementId);
    }
    
    public TwoValidate(String field, String field2, String alert, boolean allowEmpty)
    {
        this(field, field2, alert, allowEmpty, true);
    }
    
    public TwoValidate(String field, String field2, String alert, boolean allowEmpty, boolean isFocus)
    {
        this.field = field;
        this.field2 = field2;
        this.alert = alert;
        this.allowEmpty = allowEmpty;
        this.isFocus = isFocus;
    }
    
    public TwoValidate(String field, String field2, String alert, boolean allowEmpty, String elementId)
    {
        this.field = field;
        this.field2 = field2;
        this.alert = alert;
        this.allowEmpty = allowEmpty;
        this.elementId = elementId;
    }
    
    public TwoValidate(String field, String field2, String alert, boolean allowEmpty, boolean isFocus, String elementId)
    {
        this.field = field;
        this.field2 = field2;
        this.alert = alert;
        this.allowEmpty = allowEmpty;
        this.isFocus = isFocus;
        this.elementId = elementId;
    }
    
    /**
     * 获取验证字段名1
     * 
     * @return  验证字段名称1
     */
    public String getField()
    {
        return field;
    }
    
    /**
     * 获取验证字段名2
     * 
     * @return  验证字段名称2
     */
    public String getField2()
    {
        return field2;
    }
    
    /**
     * 获取告警消息
     * 
     * @return String 告警消息
     */
    public String getAlertMsg()
    {
        return alert;
    }
    
    /**
     * 验证当前信息,如果验证失败,返回false
     * 
     * @param           对值进行验证
     * @return          验证是失败还是成功
     */
    public abstract boolean validate(String value, String value2);
}
