/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd.util;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.constants.HtmlConstants;

/**
 * 样式工具类
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
@AnAlias("Styles")
public class Styles implements HtmlConstants
{
    
    public static String head()
    {
        return _STYLE_BR;
    }
    
    public static String tail()
    {
        return STYLE_;
    }
    
    public static String src(String src)
    {
        return "<link rel=\"stylesheet\" type=\"text/css\" href=\""+src+"\">";
    }
    
    public static String less(String src)
    {
        return "<link rel=\"stylesheet/less\" type=\"text/css\" href=\""+src+"\">";
    }
    
    public static String htmlOverflowHidden()
    {
        return "<style>html{overflow-x:hidden;overflow-y:hidden;}</style>";
    }
    
    public static String htmlOverflowYScroll()
    {
        return "<style>html{overflow-x:hidden;overflow-y:scroll;}</style>";
    }
    
    public static String htmlOverflowYAuto()
    {
        return "<style>html{overflow-x:hidden;overflow-y:auto;}</style>";
    }
    
    public static String bodyNoBackground()
    {
        return "<style>body{background-image:none;background:#fff}</style>";
    }
}
