/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd.nio;

import java.io.IOException;
import java.nio.ByteBuffer;

import javax.net.ssl.SSLEngine;

import org.zhiqim.httpd.HttpConnection;
import org.zhiqim.httpd.HttpException;
import org.zhiqim.httpd.HttpHeaderAbs;
import org.zhiqim.httpd.HttpInputStream;
import org.zhiqim.httpd.HttpRequestAbs;
import org.zhiqim.httpd.HttpSenderImpl;

/**
 * NIO请求头
 *
 * @version v1.4.0 @author zouzhigang 2018-3-27 新建与整理
 * @version v1.5.0 @author zouzhigang 2018-9-12 和BIO请求头抽象到HttpHeaderAbs中
 */
public class HttpNioHeader extends HttpHeaderAbs
{
    /** 构造函数 */
    public HttpNioHeader (HttpConnection conn)
    {
        this(conn, null);
    }
    
    /** 构造函数 */
    public HttpNioHeader (HttpConnection conn, SSLEngine sslEngine)
    {
        super(conn, new HttpInputStream(), sslEngine);
    }
    
    /*****************************************************************************/
    //实现不同的IO对应的抽象方法
    /*****************************************************************************/
    
    public HttpSenderImpl newSender()
    {
        return new HttpSenderImpl(this, false);
    }
    
    public HttpRequestAbs newRequest()
    {
        return new HttpNioRequest(this);
    }
    
    public boolean isBio()
    {
        return false;
    }
    
    /*****************************************************************************/
    //NIO/AIO对应的缓冲处理
    /*****************************************************************************/
    
    /** 
     * 加入缓冲列表
     * 
     * @param buf                   有缓冲数据
     * @exception HttpException     HTTP异常
     * @exception IOException       IO异常
     */
    public void addBuffer(ByteBuffer buf)
    {
        //1.第一步，把缓冲加到流中
        getInputStream().addBuffer(buf);
    }
}
