/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd.entities;

import java.io.IOException;

import org.zhiqim.httpd.HttpContext;
import org.zhiqim.httpd.HttpEntity;
import org.zhiqim.httpd.HttpException;
import org.zhiqim.httpd.HttpHeader;
import org.zhiqim.httpd.HttpSender;

import org.zhiqim.kernel.util.Strings;

/**
 * 未找到路径处理器
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class NotFoundEntity  implements HttpEntity
{
    @Override
    public boolean isMatch(String pathInContext)
    {//全匹配，在handle中处理
        return true;
    }
    
    @Override
    public void handle(HttpHeader header, HttpSender sender) throws HttpException, IOException
    {
        String pathInContext = header.getPathInContext();
        
        HttpContext context = header.getContext();
        String notFoundUrl  = context.getNotFoundUrl();
        if (notFoundUrl == null || notFoundUrl.equals(pathInContext))
        {
            sender.sendErrorHTML(_404_NOT_FOUND_);
            return;
        }
        
        //有配置未找到页面，contextPath有可能是"/"格式，要清除最后一个"/"
        String contextPath = context.getContextPath();
        contextPath = Strings.trimRight(contextPath, "/");
        
        sender.sendRedirect(contextPath + notFoundUrl);
    }
}
