/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd.entities;

import java.io.File;
import java.io.IOException;
import java.net.URL;

import org.zhiqim.httpd.HttpContext;
import org.zhiqim.httpd.HttpEntity;
import org.zhiqim.httpd.HttpException;
import org.zhiqim.httpd.HttpHeader;
import org.zhiqim.httpd.HttpSender;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Resources;
import org.zhiqim.kernel.util.Streams;

/**
 * 图标处理器
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class FaviconEnitiy implements HttpEntity
{
    private byte[] faviconBytes = null;
    private long faviconModified = 0;
    
    public FaviconEnitiy(HttpContext context)
    {
        String faviconPath = context.getResourcePath() + "/favicon.ico";
        if (context.isClasspath())
        {//类路径的，可以缓存起来
            URL url = Resources.getResource(FaviconEnitiy.class, faviconPath);
            if (url == null)
                faviconBytes = new byte[0];
            else
            {
                try
                {
                    faviconBytes = Streams.getBytesClassPath(FaviconEnitiy.class, faviconPath);
                    faviconModified = System.currentTimeMillis();
                }
                catch (IOException e)
                {
                    faviconBytes = new byte[0];
                }
            }
        }
        else
        {//文件目录，如果存在缓存
            File file = new File(faviconPath);
            if (file == null || !file.isFile() || !file.canRead())
                return;
            
            try
            {
                faviconBytes = Streams.getBytesFilePath(file);
                faviconModified = file.lastModified();
            }
            catch (IOException e)
            {
                faviconBytes = null;
            }
        }
    }
    
    public boolean isMatch(String pathInContext)
    {
        return _PATH_FAVICON_.equals(pathInContext);
    }
    
    public void handle(HttpHeader request, HttpSender response) throws HttpException, IOException
    {
        HttpContext context = request.getContext();
        String faviconPath = context.getResourcePath() + "/favicon.ico";
        
        if (context.isClasspath())
        {//类路径的，以缓存为准即可
            if (faviconBytes.length == 0)
            {
                response.sendError(_404_NOT_FOUND_);
                return;
            }
        }
        else
        {//文件目录，需要检查是否被替换
            File file = new File(faviconPath);
            if (file == null || !file.isFile() || !file.canRead())
            {
                response.sendError(_404_NOT_FOUND_);
                return;
            }
            
            if (faviconModified != file.lastModified())
            {
                faviconModified = file.lastModified();
                faviconBytes = Streams.getBytesFilePath(file);
            }
        }
        
        String ifModifiedSince = request.getHeader(_IF_MODIFIED_SINCE_);
        String faviconModifiedHttp = DateTimes.getDateTimeHttp(faviconModified);
        if (ifModifiedSince != null && ifModifiedSince.indexOf(faviconModifiedHttp) != -1)
        {//时间相等
            response.setHeader(_CACHE_CONTROL_, "max-age=3600, public");
            response.sendError(_304_NOT_MODIFIED_);
            return;
        }

        response.setContentType("image/x-icon");
        response.setHeader(_ACCEPT_RANGES_, _BYTES_);
        response.setHeader(_LAST_MODIFIED_, faviconModifiedHttp);
        response.setHeader(_CACHE_CONTROL_,"max-age=3600, public");
        response.write(faviconBytes);
        response.commit();
    }
}
