/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd.entities;

import java.io.File;
import java.io.IOException;
import java.net.URL;

import org.zhiqim.httpd.HttpContext;
import org.zhiqim.httpd.HttpEntity;
import org.zhiqim.httpd.HttpHeader;
import org.zhiqim.httpd.HttpSender;

import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Streams;

/**
 * 跨域处理器
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class CrossdomainEntity implements HttpEntity
{
    private byte[] crossdomainBytes = null;
    private String crossdomainModified = null;
    
    public CrossdomainEntity(HttpContext context)
    {
        try
        {
            if (crossdomainModified != null)
                return;
            
            crossdomainModified = DateTimes.getDateTimeHttp();
            String crossdomainPath = context.getResourcePath() + "/crossdomain.xml";
            if (context.isClasspath())
            {
                URL url = this.getClass().getResource(crossdomainPath);
                if (url == null)
                    crossdomainBytes = Streams.getBytesClassPath(CrossdomainEntity.class, _PATH_CROSSDOMAIN_XML_);
                else
                    crossdomainBytes = Streams.getBytesClassPath(CrossdomainEntity.class, crossdomainPath);
            }
            else
            {
                File file = new File(crossdomainPath);
                if (file == null || !file.isFile() || !file.canRead())
                    crossdomainBytes = Streams.getBytesClassPath(CrossdomainEntity.class, _PATH_CROSSDOMAIN_XML_);
                else
                    crossdomainBytes = Streams.getBytesFilePath(file);
            }
        }
        catch (IOException e)
        {
            crossdomainBytes = new byte[0];
        }
    }
    
    @Override
    public boolean isMatch(String pathInContext)
    {
        return _PATH_CROSSDOMAIN_.equals(pathInContext);
    }
    
    @Override
    public void handle(HttpHeader request, HttpSender response) throws IOException
    {
        String ifModifiedSince = request.getHeader(_IF_MODIFIED_SINCE_);
        if (ifModifiedSince != null && ifModifiedSince.indexOf(crossdomainModified) != -1)
        {//时间相等
            response.setHeader(_PRAGMA_, _NO_CACHE_);
            response.setHeader(_CACHE_CONTROL_, _NO_CACHE_);
            response.sendError(_304_NOT_MODIFIED_);
            return;
        }

        response.setHeader(_LAST_MODIFIED_, crossdomainModified);
        response.setContentType(_TEXT_CDP_);
        response.setHeader(_PRAGMA_, _NO_CACHE_);
        response.setHeader(_CACHE_CONTROL_, _NO_CACHE_);
        if (request.isMethodResponseContent())
            response.write(crossdomainBytes);
        response.commit();
    }
}
