/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd.context.service;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;

import org.zhiqim.httpd.HttpContext;
import org.zhiqim.httpd.HttpExecutor;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.HttpResponse;
import org.zhiqim.httpd.constants.HttpMimeType;
import org.zhiqim.httpd.context.ZmlContextConstants;

import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Files;
import org.zhiqim.kernel.util.Resources;
import org.zhiqim.kernel.util.Streams;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;

/**
 * 资源文件服务
 * /service/res/*
 * 
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class ResourceService implements HttpExecutor, ZmlContextConstants
{
    private static final Log log = LogFactory.getLog(ResourceService.class);
    
    private final HashMap<String, byte[]> resourceMap = new HashMap<String, byte[]>();
    private final String lastModifiedTime = DateTimes.getDateTimeHttp();
    
    public ResourceService()
    {
        try
        {
            //本目录下文件
            List<String> fileNameList = Resources.getResourceFileNameList(ResourceService.class, _SERV_RESOURCE_CLASSPATH_);
            
            List<String> imageList = Resources.getResourceFileNameList(ResourceService.class, _SERV_RESOURCE_CLASSPATH_ + "image/");
            for (String image : imageList)
            {//image文件
                fileNameList.add("image/"+image);
            }
            
            List<String> fontList = Resources.getResourceFileNameList(ResourceService.class, _SERV_RESOURCE_CLASSPATH_ + "font/");
            for (String font : fontList)
            {//font文件
                fileNameList.add("font/"+font);
            }
            
            List<String> swfList = Resources.getResourceFileNameList(ResourceService.class, _SERV_RESOURCE_CLASSPATH_ + "swf/");
            for (String swf : swfList)
            {//swf文件
                fileNameList.add("swf/"+swf);
            }
            
            for (String fileName : fileNameList)
            {//对文件缓存
                resourceMap.put(fileName, Streams.getBytesClassPath(ResourceService.class, _SERV_RESOURCE_CLASSPATH_ + fileName));
            }
        }
        catch (IOException e)
        {
            log.error("初始化系统资源文件时失败", e);
        }
    }
    
    @Override
    public boolean isMatch(String pathInContext)
    {
        return Validates.isMatch(pathInContext, _PATH_SERVICE_RESOURCE_);
    }
    
    @Override
    public void handle(HttpRequest request, HttpResponse response) throws IOException
    {
        HttpContext context = request.getContext();
        String path = request.getPathInContext();
        String name = Strings.removeStartsWith(path, "/service/res/");
        if (!resourceMap.containsKey(name))
        {//不存在
            response.sendError(_404_NOT_FOUND_);
            return;
        }
        
        String ifModifiedSince = request.getHeader(_IF_MODIFIED_SINCE_);
        if (ifModifiedSince != null && ifModifiedSince.indexOf(lastModifiedTime) != -1)
        {//如果有要求未修改返回304
            response.setHeader(_CACHE_CONTROL_, _MAX_AGE_+"="+context.getExpires());
            response.sendHeader(_304_NOT_MODIFIED_);
            return;
        }
        
        //找到则设置响应属性
        String fileExt = Files.getFileExt(path);
        String mimeType = request.getMimeType();
        if (mimeType == null)
            mimeType = HttpMimeType.getResourceMimeType(fileExt);

        if (mimeType != null)//强制UTF-8
            response.setContentType(mimeType+"; charset="+_UTF_8_);
        
        //设置响应内容属性
        response.setCharacterEncoding(_UTF_8_);
        response.setHeader(_ACCEPT_RANGES_, _BYTES_);
        response.setHeader(_LAST_MODIFIED_, lastModifiedTime);
        
        if (request.isMethodResponseContent())
        {//GET,POST
            byte[] content = resourceMap.get(name);
            response.setHeader(_CONTENT_LENGTH_, content.length);
            response.setHeader(_CACHE_CONTROL_, _MAX_AGE_+"="+context.getExpires());
            response.write(content);
        }
        
        response.commit();
    }
}
