/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd.context.extend;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.core.Action;


/**
 * 包括一个View和一个Exec的Action，常用于页面和处理合并到一个Action
 * 
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public abstract class ViewExecAction implements Action
{
    /** 设置为final，防止子类重写 */
    public final void execute(HttpRequest request) throws Exception
    {
        String method = request.getExecuteMethod();
        if(EXEC.equalsIgnoreCase(method))
        {//处理，先把验证数据放入，再验证，失败退出，成功清除验证后执行
            validate(request);
            if (!request.chkValidate())
            {
                request.returnHistory();
                return;
            }
            
            request.clearValidate();
            exec(request);
        }
        else
        {
            request.setResponsePrivateCache();
            request.setAlertMsg(null);
            validate(request);//增加验证到forward
            view(request);
        }
    }

    /**
     * 增加验证,默认通过,子类可重写该方法
     * 
     * @param forward ActionForward
     */
    protected void validate(HttpRequest request) throws Exception
    {
    }
    
    /** view方法，由子类实现 */
    protected abstract void view(HttpRequest request) throws Exception;
    
    /** exec方法，由子类实现 */
    protected abstract void exec(HttpRequest request) throws Exception;
}
