/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd.context.extend;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.core.Action;

import org.zhiqim.kernel.util.Validates;

/**
 * 标准Action分发器,标准分发器提供validateForm表单检查<br><br>
 * 
 * 包括方法如下:<br>
 * 0)validate   (用于add,modify页面验证和insert,update的服务端验证)<br>
 * 1)item       (用于显示单条详情)<br>
 * 2)list       (用于显示列表,如分页,查询都在这里)<br>
 * 3)add        (用于增加操作的页面初始化)<br>
 * 4)modify     (用于修改操作的页面初始化)<br>
 * 5)insert     (用于增加操作的执行)<br>
 * 6)update     (用于修改操作的执行)<br>
 * 7)delete     (用于删除操作的执行)<br>
 * 
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public abstract class StdSwitchAction implements Action
{
    /** 设置为final，防止子类重写 */
    public final void execute(HttpRequest request) throws Exception
    {
        String method = request.getExecuteMethod();
        if (Validates.isEmptyBlank(method))
            method = LIST;
        
        switch (method.hashCode())
        {
        case INT_ITEM:
            validateId(request);
            if (!request.chkValidate())
            {
                request.returnHistory();
                break;
            }
            
            request.clearValidate();
            item(request);
            break;
        case INT_ADD:
            request.setResponsePrivateCache();
            request.setAlertMsg(null);
            validateForm(request);
            add(request);
            break;
        case INT_MODIFY:
            validateId(request);
            if (!request.chkValidate())
            {
                request.returnHistory();
                break;
            }
            
            request.clearValidate();
            request.setResponsePrivateCache();
            request.setAlertMsg(null);
            validateForm(request);
            modify(request);
            break;
        case INT_INSERT:
            validateForm(request);
            if (!request.chkValidate())
            {
                request.returnHistory();
                break;
            }
            
            request.clearValidate();
            insert(request);
            break;
        case INT_UPDATE:
            validateForm(request);
            if (!request.chkValidate())
            {
                request.returnHistory();
                break;
            }
            
            request.clearValidate();
            update(request);
            break;
        case INT_DELETE:
            validateId(request);
            if (!request.chkValidate())
            {
                request.returnHistory();
                break;
            }
            
            request.clearValidate();
            delete(request);
            break;
        default:
            list(request);
            break;
        }
    }
    

    /** 验证ID,用于item,modify,delete时检查ID是否传入 */
    protected abstract void validateId(HttpRequest request) throws Exception; 
    
    /** 验证表单,用于add,modify作客户端javascript验证,用于insert,update作服务端验证 */
    protected abstract void validateForm(HttpRequest request) throws Exception; 
    
    /** 1)item  (用于显示单条详情) 可选 */
    protected void item(HttpRequest request) throws Exception
    {
    }
    
    /** 2)list     (用于显示列表,如分页,查询都在这里) */
    protected abstract void list(HttpRequest request) throws Exception;

    /** 3)add    (用于增加操作的页面初始化) */
    protected abstract void add(HttpRequest request) throws Exception;

    /** 4)modify(用于修改操作的页面初始化) */
    protected abstract void modify(HttpRequest request) throws Exception;

    /** 5)insert(用于增加操作的执行) */
    protected abstract void insert(HttpRequest request) throws Exception;

    /** 6)update(用于修改操作的执行) */
    protected abstract void update(HttpRequest request) throws Exception;

    /** 7)delete(用于删除操作的执行) */
    protected abstract void delete(HttpRequest request) throws Exception;
}
