/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd.context.core;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.ZmlContextConstants;
import org.zhiqim.httpd.context.returns.ReturnView;

import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;

/**
 * 定义响应页面接口
 *
 * @version v1.0.0 @author zouzhigang 2017-8-19 新建与整理
 */
public interface Return extends ZmlContextConstants
{
    public static final Log log = LogFactory.getLog(Return.class);
    public static final ReturnView returnTemplate = new ReturnView();
    
    /**
     * 执行输出操作，用于Action处理完成之后，根据结果进行输出.
     * 
     * @param request          HTTP请求
     * @throws Exception       允许抛出Exception
     */
    public void process(HttpRequest request) throws Exception;
}
