/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd.context.core;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.HttpdConstants;

/**
 * 定义拦截器接口，处理结果放置在request属性_RESPONSE_STATUS_和_RESPONSE_TEXT_中
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 * @version v1.1.0 @author zouzhigang 2015-11-19 修改原三个参数[forward,request,response]为只保留request参数
 */
public interface Interceptor extends HttpdConstants
{
    /**
     * 执行拦截操作,用于Action,Ajax,RMI等操作之前进行的拦截操作, 如用户身份验证,日志等操作.
     * 
     * @param request          HTTP请求
     * @throws Exception       允许抛出Exception
     */
    public void intercept(HttpRequest request) throws Exception;
}