/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd.context.core;

import java.util.List;

import org.zhiqim.httpd.HttpContext;
import org.zhiqim.httpd.context.ZmlBootstrap;
import org.zhiqim.httpd.context.ZmlConfig;
import org.zhiqim.httpd.context.ZmlContextConstants;
import org.zhiqim.httpd.context.ServiceExecutor;
import org.zhiqim.httpd.context.config.ZAction;

import org.zhiqim.zml.ZmlEngine;

/**
 * ZML上下文环境必须实现的接口
 *
 * @version v1.0.0 @author zouzhigang 2016-7-16 新建与整理
 */
public interface Context extends HttpContext, ZmlContextConstants
{
    /***************************************************************************************/
    //Bootstrap & RmiService & ZmlEngine
    /***************************************************************************************/
    
    /** 获取服务Id */
    public String getServerId();
    
    /** 获取配置类 */
    public ZmlConfig getConfig();
    
    /** 获取引导类 */
    public ZmlBootstrap getBootstrap();
    
    /** 获取ZML引擎类 */
    public ZmlEngine getZmlEngine();
    
    /** 获取服务处理器 */
    public ServiceExecutor getServiceExecutor();
    
    /***************************************************************************************/
    //TopAttribute
    /***************************************************************************************/
    
    /** 判断是否有顶级属性 */
    public boolean hasTopAttribute(String key);
    
    /** 获取顶有属性对象 */
    public Object getTopAttribute(String key);
    
    /** 获取顶有属性字符串 */
    public String getTopAttributeString(String key);
    
    /** 获取顶有属性字符串，有属性则返回字符串，否则返回缺省值 */
    public String getTopAttributeString(String key, String defaultValue);
    
    /***************************************************************************************/
    //Action & Interceptor
    /***************************************************************************************/
    
    /**
     * 通过ZAction配置获取Action实例
     * 
     * @param fAction       ZAction配置
     * @return              Action实例
     */
    public Action getAction(ZAction fAction);
    
    /**
     * 判断类是否在ActionMap中
     * 
     * @param clazz         类名
     * @return              =true表示存在
     */
    public boolean hasActionInstance(String clazz);
    
    /**
     * 获取类在ActionMap中的实例
     * 
     * @param clazz         类名
     * @return              Action实例
     */
    public Action getActionInstance(String clazz);
    
    /**
     * 获取Action配置
     * 
     * @param path          路径，如/index.htm
     * @return              Action配置
     */
    public ZAction getAction(String path);
    
    /**
     * 判断是否有该别名的拦截器
     * 
     * @param interceptor   拦截器别名
     * @return              =true表示有，=false表示没有
     */
    public boolean hasInterceptor(String interceptor);
    
    /**
     * 获取该别名的拦截器
     * 
     * @param interceptor   拦截器别名
     * @return              拦截器
     */
    public Interceptor getInterceptor(String interceptor);
    
    /**
     * 通过拦截器别名字符串获取拦截器列表
     * 
     * @param interceptors  拦截器别名字符串，多个用逗号隔开
     * @return              拦截器列表
     */
    public List<Interceptor> getInterceptorList(String interceptors);
    
    /***************************************************************************************/
    //资源相关
    /***************************************************************************************/
    
    /**
     * 增加组件资源
     * 
     * @param resourceIndex 资源查找索引，从小到大查找
     * @param resourceType  资源类型classpath|directory
     * @param resourcePath  资源地址，如/com/zhiqim/example或./example
     * @return              =true表示成功，=false表示已存在
     */
    public boolean addComponentResource(int resourceIndex, String resourceType, String resourcePath);
}
