/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd.context.config;

import org.zhiqim.httpd.HttpWebsocket;
import org.zhiqim.httpd.context.ZmlBootstrap;
import org.zhiqim.httpd.context.ZmlConfig;
import org.zhiqim.httpd.context.ZmlContextConstants;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Classes;
import org.zhiqim.kernel.util.Validates;

/**
 * 组件上下文环境和ZML引擎管理
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class ZComponentWapper implements ZmlContextConstants
{
    private final ZComponent component;
    
    private final ZConfig config;
    private final ZActionPackage actionPackage;
    private HttpWebsocket websocket;
    private ZmlBootstrap bootstrap;
    
    public ZComponentWapper(ZmlConfig zmlConfig, ZComponent component)
    {
        this.component = component;
        this.config = new ZConfig(zmlConfig, false, _CLASSPATH_, component.getPath(), component.getName(), ZC_CONF_CONFIG_XML);
        this.actionPackage = config.getActionPackage(zmlConfig);
    }
    
    public void load() throws Exception
    {
        //加载context.xml
        config.load();
        
        if (actionPackage != null)
        {//加载actionPackage
            actionPackage.load();
        }
    }
    
    public String getPath()
    {
        return this.component.getPath();
    }
    
    public HttpWebsocket getWebsocket()
    {
        if (websocket != null)
            return websocket;
        
        String cls = config.getWebsocketClass();
        if (Validates.isEmptyBlank(cls))
            return null;
        
        Object instance = Classes.newInstance(cls.trim());
        Asserts.as((instance instanceof HttpWebsocket)?null:"组件["+component.getName()+"]配置的[websocket]不是HttpWebsocket实现类");
        websocket = (HttpWebsocket)instance;
        return websocket;
    }
    
    public ZmlBootstrap getBootstrap()
    {
        if (bootstrap != null)
            return bootstrap;
        
        String cls = config.getBootstrapClass();
        if (Validates.isEmptyBlank(cls))
            return null;
        
        Object instance = Classes.newInstance(cls.trim());
        Asserts.as((instance instanceof ZmlBootstrap)?null:"组件["+component.getName()+"]配置的[bootstrap]不是ZmlBootstrap或其子类");
        bootstrap = (ZmlBootstrap)instance;
        bootstrap.setContext(config.getContext());
        return bootstrap;
    }
    
    public ZConfig getConfig()
    {
        return config;
    }
    
    /** 由Action包增加的@AnAction配置 */
    public void addActionOnPackage(ZAction action)
    {
        if (actionPackage != null)
            actionPackage.addActionOnPackage(action);
    }
    
    /*****************************************************************************/
    //通过pathInContext 获取ZAction
    /*****************************************************************************/
    
    public ZAction getActionInTurn(String path)
    {
        //1.先查根配置
        ZAction action = config.getInTurnAction(path);
        if (action != null)
            return action;
        
        //2.再查actionPackage
        if (actionPackage != null)
        {
            action = actionPackage.getInTurnAction(path);
            if (action != null)
                return action;
        }
        
        return null;
    }
    
    
    public ZAction getExactAction(String path)
    {
        //1.先查根配置
        ZAction action = config.getExactAction(path);
        if (action != null)
            return action;
        
        //2.再查actionPackage
        if (actionPackage != null)
        {
            action = actionPackage.getExactAction(path);
            if (action != null)
                return action;
        }
        
        return null;
    }
    
    public ZAction getFuzzyAction(String path)
    {
        //1.先查根配置
        ZAction action = config.getFuzzyAction(path);
        if (action != null)
            return action;
        
        //2.再查actionPackage
        if (actionPackage != null)
        {
            action = actionPackage.getFuzzyAction(path);
            if (action != null)
                return action;
        }
        
        return null;
    }
    
    /*****************************************************************************/
    //通过class 获取 path
    /*****************************************************************************/
    
    public ZAction getInTurnActionByClass(String clazz)
    {
        //1.先查根配置
        ZAction action = config.getInTurnActionByClass(clazz);
        if (action != null)
            return action;
        
        //2.再查actionPackage
        if (actionPackage != null)
        {
            action = actionPackage.getInTurnActionByClass(clazz);
            if (action != null)
                return action;
        }
        
        return null;
    }
    
    public ZAction getExactActionByClass(String clazz)
    {
        //1.先查根配置
        ZAction action = config.getExactActionByClass(clazz);
        if (action != null)
            return action;
        
        //2.再查actionPackage
        if (actionPackage != null)
        {
            action = actionPackage.getExactActionByClass(clazz);
            if (action != null)
                return action;
        }
        
        return null;
    }
    
    public ZAction getFuzzyActionByClass(String clazz)
    {
        //1.先查根配置
        ZAction action = config.getFuzzyActionByClass(clazz);
        if (action != null)
            return action;
        
        //2.再查actionPackage
        if (actionPackage != null)
        {
            action = actionPackage.getFuzzyActionByClass(clazz);
            if (action != null)
                return action;
        }
        
        return null;
    }
}
