/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd.context.config;

import java.io.IOException;
import java.io.InputStream;

import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.zhiqim.httpd.context.ZmlContextConstants;

import org.zhiqim.kernel.util.Resources;

/**
 * 实现DTD本地验证,这样则不要到zhiqim.org下载验证 <br>
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class ZCResolver implements EntityResolver, ZmlContextConstants
{
    private String path;
    
    public ZCResolver(String path)
    {
        this.path = path;
    }
    
    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException 
    {
        if (!ZC_DTD_PUBLIC_ID.equals(publicId))
        {//版本不支持
            throw new SAXException("配置文件["+path+"]格式不正确，["+ZC_VERSION+"]仅支持["+ZC_DTD_PUBLIC_ID+"]格式");
        }
        
        InputStream stream = Resources.getResourceStream(ZCResolver.class, ZC_DTD_PATH);
        return new InputSource(stream);
    }
}
