/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd.context.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * Action注解定义，所有Action注解需在指定的package下，便于加载时缩小范围和组件之间不冲突
 * 
 * 1.可以在类上定义，表示该类是一个Action，那么该类必须是Action的子类，实现了execute方法
 * 2.可以在类的方法上定义，表示该类的方法是一个Action，那么该类方法必须实现和execute一样的参数
 * 3.拦截器另外使用 @see @AnInterceptor 注解
 * 
 * <!ELEMENT action EMPTY>
 * <!ATTLIST action name CDATA #REQUIRED>
 * <!ATTLIST action path CDATA #REQUIRED>
 * <!ATTLIST action interceptor CDATA #IMPLIED>
 * <!ATTLIST action forward CDATA #IMPLIED>
 * <!ATTLIST action redirect CDATA #IMPLIED>
 * <!ATTLIST action view CDATA #IMPLIED>
 * <!ATTLIST action include CDATA #IMPLIED>
 * <!ATTLIST action class CDATA #IMPLIED>
 * <!ATTLIST action method CDATA #IMPLIED>
 * <!ATTLIST action success CDATA #IMPLIED>
 * <!ATTLIST action tips CDATA #IMPLIED>
 * <!ATTLIST action sessionUser CDATA #IMPLIED>
 *
 * @version v1.0.0 @author zouzhigang 2016-7-14 新建与整理
 */
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface AnAction
{
    /*************************************************************************************/
    //name & path 必须
    /*************************************************************************************/
    
    /** 名称 */
    String name();
    
    /** 访问路径 */
    String path();
    
    /*************************************************************************************/
    //view & forward & redirect 三都只选其一
    /*************************************************************************************/

    /** 内部转向视图 */
    String view() default "";
    
    /** 内部转向视图包括地址，多个用逗号隔开 */
    String include() default "";
    
    /** 内部转向新的地址 */
    String forward() default "";
    
    /** 外部重定向 */
    String redirect() default "";

    /*************************************************************************************/
    //表示操作完成后的成功提示，为空表示不提示，一般用于执行页，如增加成功等
    /*************************************************************************************/
    
    /** 操作确认提示 */
    String success() default "";
    
    /** 操作冒泡提示 */
    String tips() default "";
    
    /** 会话用户类 */
    String sessionUser() default "";
}
