/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd.context;

import org.zhiqim.httpd.HttpdConstants;
import org.zhiqim.httpd.context.extend.EmptyAction;

/**
 * 定义上下文常量
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public interface ZmlContextConstants extends HttpdConstants
{
    /********************************************************************************/
    //第一部分，ZML参数配置定义服务配置定义expires      
    /********************************************************************************/
    
    public static final String _ZML_PATH_EXACTPRIOR_                = "pathExactPrior";
    
    public static final String _ZML_COOKIE_USE_                     = "cookie.use";
    public static final String _ZML_COOKIE_DOMAIN_                  = "cookie.domain";
    public static final String _ZML_COOKIE_PORT_                    = "cookie.port";
    public static final String _ZML_COOKIE_PATH_                    = "cookie.path";
    
    public static final String _ZML_SESSION_MANAGER_                = "session.manager";
    public static final String _ZML_SESSION_TIMEOUT_                = "session.timeout";
    public static final String _ZML_SESSION_ID_NAME_                = "session.idName";
    public static final String _ZML_SESSION_PARAMETER_              = "session.parameter";

    public static final String _ZML_PATTERN_                        = "zml.pattern";
    public static final String _ZML_MAX_KEEP_TIME_                  = "zml.maxKeepTime";
    public static final String _ZML_MAX_IDLE_TIME_                  = "zml.maxIdleTime";
    
    public static final String _ZML_PATTERN_DEFAULT_                = "*.zml,*.htm";
    
    /********************************************************************************/
    //第二部分，ZML服务配置定义 zml
    /********************************************************************************/
    
    //服务提供定义的路径服务
    public static final String _PATH_SERVICE_                       = "/service/*";
    public static final String _PATH_SERVICE_AJAX_                  = "/service/ajax";
    public static final String _PATH_SERVICE_RMI_                   = "/service/rmi";
    public static final String _PATH_SERVICE_UPLOAD_                = "/service/upload";
    public static final String _PATH_SERVICE_UPLOAD_ACCESS_         = "/service/upl/*";
    public static final String _PATH_SERVICE_VCODE_                 = "/service/vcode.jpg";
    public static final String _PATH_SERVICE_RESOURCE_              = "/service/res/*";
    public static final String _PATH_SERVICE_RES_AVATAR_            = "/service/res/image/pic_avatar.jpg";
    
    //服务前置
    public static final String _PATH_SERVICE_PREFIX_                = "/service/";
    public static final String _PATH_RESOURCE_PREFIX_               = "/service/res/";
    public static final String _PATH_UPLOAD_PREFIX_                 = "/service/upl/";
    
    //服务常用属性
    public static final String _SERV_AJAX_INTERCEPTOR_              = "ajax.interceptor";
    
    public static final String _SERV_UPLOAD_FORWARD_                = "upload.foward";
    public static final String _SERV_UPLOAD_ACCESS_                 = "upload.access";
    public static final String _SERV_UPLOAD_ROOT_DIR_               = "upload.rootDir";
    
    public static final String _SERV_IP_WHITE_LIST_SUFFIX_          = ".ipWhiteList";
    public static final String _SERV_IP_BLACK_LIST_SUFFIX_          = ".ipBlackList";
    public static final String _SERV_IP_DEFAULT_PERMISSION_         = ".ipDefaultPermission";
    
    public static final String _SERV_RESOURCE_CLASSPATH_            = "/org/zhiqim/httpd/context/service/resource/";
    
    /********************************************************************************/
    //第三部分，ZML上下文环境常量定义
    /********************************************************************************/
    
    /** ZC 目录和服务 */
    public static final String ZC_CONF_FOLDER                       = "/conf/";
    public static final String ZC_CONF_CONFIG_XML                   = "/conf/config.xml";
    public static final String ZC_CONF_CONFIG_ZML                   = "/conf/config.zml";
    public static final String ZC_FILTER_CONF_FILE                  = "/conf/*";
    public static final String ZC_FILTER_ZVIEW_FILE                 = "/zview/*";
    public static final String ZC_FILTER_ZTMPL_HTM                  = "/ztmpl/*.htm";
    public static final String ZC_FILTER_ZTMPL_ZML                  = "/ztmpl/*.zml";
    public static final String ZC_RES_ZTMPT_FILE                    = "/ztmpl/*";
    public static final String ZC_RES_ZRES_FILE                     = "/zres/*";

    public static final String ZC_MATCH_PREFIX                      = "_match_";
    public static final String ZC_VCODE_SESSION_NAME                = "_vcode_";
    public static final String ZC_EMPTY_ACTION_NAME                 = EmptyAction.class.getName();
    
    /** ZC 属性名多组件内多个 */
    public static final String ZC_WEBSOCKET                         = "websocket";
    public static final String ZC_BOOTSTRAP                         = "bootstrap";
    public static final String ZC_ACTION_PACKAGE                    = "actionPackage";
    
    /** ZC 属性名组件依次重写 */
    public static final String ZC_ZHIQIM_CSS                        = "zhiqim.css";
    public static final String ZC_ZHIQIM_JS                         = "zhiqim.js";
    
    public static final String ZC_ZHIQIM_MOBILE_CSS                 = "zhiqim.mobile.css";
    public static final String ZC_ZHIQIM_MOBILE_JS                  = "zhiqim.mobile.js";
    
    /********************************************************************************/
    //第四部分，ZML上下文配置文件常量定义
    /********************************************************************************/
    
    /** ZC DTD/XML格式 */
    public static final String ZC_VERSION                           = "V1.5.0";
    public static final String ZC_DTD_PUBLIC_ID                     = "-//ZHIQIM //DTD Zhiqim-Context Configuration 1.5.0//EN";
    public static final String ZC_DTD_PATH                          = "/org/zhiqim/httpd/context/config/zhiqim_context_1_5_0.dtd";
    public static final String ZC_DTD_URL                           = "http://zhiqim.org/xmldtds/zhiqim_context_1_5_0.dtd";
    
    public static final String ZC_XML_DOCTYPE                       = "<!DOCTYPE ZHIQIM-CONTEXT PUBLIC \""+ ZC_DTD_PUBLIC_ID+ "\" \""+ ZC_DTD_URL +"\">";
    
    public static final String ZC_XML_HEAD                          = "<zhiqim-context>";
    public static final String ZC_XML_TAIL                          = "</zhiqim-context>";
    
    /** ZC 核心定义，包括组件、子环境、宏定义、属性、拦截器和执行器 */
    public static final String ZC_COMPONENT                         = "component";
    public static final String ZC_CONFIG                            = "config";
    public static final String ZC_ATTRIBUTE                         = "attribute";
    public static final String ZC_INTERCEPTOR                       = "interceptor";
    public static final String ZC_SESSION_USER                      = "sessionUser";
    public static final String ZC_ACTION                            = "action";
    
    /** ZC 字段名 */
    public static final String ZC_NAME                              = _NAME_;
    public static final String ZC_TYPE                              = _TYPE_;
    public static final String ZC_KEY                               = _KEY_;
    public static final String ZC_VALUE                             = _VALUE_;
    public static final String ZC_CLASS                             = _CLASS_;
    public static final String ZC_PATH                              = "path";
    public static final String ZC_FORWARD                           = "forward";
    public static final String ZC_REDIRECT                          = "redirect";
    public static final String ZC_VIEW                              = "view";
    public static final String ZC_INCLUDE                           = "include";
    public static final String ZC_METHOD                            = "method";
    public static final String ZC_SUCCESS                           = "success";
    public static final String ZC_TIPS                              = "tips";
    
    /********************************************************************************/
    //第五部分，响应常量定义
    /********************************************************************************/
    
    public static final String _PATH_RETURN_RESULT_                 = "/conf/return/returnResult.zml";
    public static final String _PATH_RETURN_FRAME_                  = "/conf/return/returnFrame.zml";
    
    /********************************************************************************/
    //第六部分，Service/Action等常量定义
    /********************************************************************************/
    
    /** ZC Action常用的配置 */
    public static final String EXEC                                 = "exec";
    public static final String LIST                                 = "list";
    public static final int INT_LIST                                = 3322014;      //"list".hashCode();
    public static final int INT_ITEM                                = 3242771;      //"item".hashCode();
    public static final int INT_ADD                                 = 96417;        //"add".hashCode();
    public static final int INT_MODIFY                              = -1068795718;  //"modify".hashCode();
    public static final int INT_INSERT                              = -1183792455;  //"insert".hashCode();
    public static final int INT_UPDATE                              = -838846263;   //"update".hashCode();
    public static final int INT_DELETE                              = -1335458389;  //"delete".hashCode();
}
