/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd.context;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

import org.zhiqim.httpd.HttpExecutor;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.HttpResponse;
import org.zhiqim.httpd.HttpWebsocketService;
import org.zhiqim.httpd.context.service.AjaxService;
import org.zhiqim.httpd.context.service.ResourceService;
import org.zhiqim.httpd.context.service.RmiService;
import org.zhiqim.httpd.context.service.UploadAccessService;
import org.zhiqim.httpd.context.service.UploadService;
import org.zhiqim.httpd.context.service.VcodeService;

import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Validates;

/**
 * 服务处理器，对应 /service/* 的地址 
 *
 * @version v1.0.0 @author zhichenggang 2017-1-6 新建与整理
 */
public class ServiceExecutor implements HttpExecutor, ZmlContextConstants
{
    private HashMap<String, HttpExecutor> executorMap = new HashMap<>();
    private ArrayList<HttpExecutor> executors = new ArrayList<>();
    
    public ServiceExecutor()
    {
        //5个精确定位
        executorMap.put(_PATH_SERVICE_AJAX_,        new AjaxService());
        executorMap.put(_PATH_SERVICE_RMI_,         new RmiService());
        executorMap.put(_PATH_SERVICE_VCODE_,       new VcodeService());
        executorMap.put(_PATH_SERVICE_UPLOAD_,      new UploadService());
        executorMap.put(_PATH_SERVICE_WS_,          new HttpWebsocketService());
        
        //2个模糊匹配
        executors.add(new ResourceService());
        executors.add(new UploadAccessService());
        executors.trimToSize();
    }
    
    @Override
    public boolean isMatch(String pathInContext)
    {
        return Validates.isMatch(pathInContext, _PATH_SERVICE_);
    }

    @Override
    public void handle(HttpRequest request, HttpResponse response) throws IOException
    {
        HttpExecutor executor = getMatchExecutor(request.getPathInContext());
        if (executor != null)
            executor.handle(request, response);
        else
            request.getContext().getNotFoundHandler().handle(request, response);
    }
    
    public RmiService getRmiService()
    {
        return (RmiService)executorMap.get(_PATH_SERVICE_RMI_);
    }
    
    public void addService(String path, HttpExecutor service)
    {
        Asserts.as(Validates.isLen(path, 10, 100) && path.startsWith("/service/")?null:"增加ZML上下文环境下服务时，path必须以/service/开头，最长100字符");
        Asserts.as(service != null?null:"增加ZML上下文环境下服务时，服务不能为null");
        
        if (path.contains("*"))
            executors.add(service);
        else
            executorMap.put(path, service);
    }

    /** 匹配对应的Handler */
    private HttpExecutor getMatchExecutor(String pathInContext)
    {
        //1.先精确
        HttpExecutor executor = executorMap.get(pathInContext);
        if (executor != null)
            return executor;
        
        //2.后模糊
        for (HttpExecutor handler : executors)
        {
            if (handler.isMatch(pathInContext))
                return handler;
        }

        return null;
    }
}
