/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd.constants;

import java.util.HashMap;

import org.zhiqim.httpd.HttpdConstants;

/**
 * HTTP处理步骤
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class HttpStep implements HttpdConstants
{
    private static final HashMap<Integer, String> _statusMsg = new HashMap<Integer, String>();
    
    static
    {
        _statusMsg.put(_01_CREATE_,                     _01_STEP_DESC_);
        _statusMsg.put(_02_PARSE_HEADER_,               _02_STEP_DESC_);
        _statusMsg.put(_03_CHECK_HEADER_,               _03_STEP_DESC_);
        _statusMsg.put(_04_QUERY_CONTEXT_,              _04_STEP_DESC_);
        _statusMsg.put(_05_QUERY_HANDLER_,              _05_STEP_DESC_);
        _statusMsg.put(_06_PARSE_CONTENT_,              _06_STEP_DESC_);
        _statusMsg.put(_07_HANDLER_BEGIN_,              _07_STEP_DESC_);
        _statusMsg.put(_08_INTERCEPTOR_,                _08_STEP_DESC_);
        _statusMsg.put(_09_ACTION_,                     _09_STEP_DESC_);
        _statusMsg.put(_10_HANDLER_END_,                _10_STEP_DESC_);
        _statusMsg.put(_11_COMMITTED_,                  _11_STEP_DESC_);
        _statusMsg.put(_12_FINISHED_,                   _12_STEP_DESC_);
    }
    
    public static final String getStatusMsg(int code)
    {
        String desc = _statusMsg.get(code);
        return desc==null?""+code:desc;
    }
}
