/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd.constants;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import org.zhiqim.httpd.HttpdConstants;

import org.zhiqim.kernel.util.Resources;
import org.zhiqim.kernel.util.Validates;

/**
 * HTTP协议中MIME类型定义
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class HttpMimeType implements HttpdConstants
{
    private static Properties p = null;
    
    static
    {
        if (p == null)
        {
            p = new Properties();
            InputStream in = Resources.getResourceStream(HttpMimeType.class, _PATH_MIME_PROPERTIES_);
            try{p.load(in);}catch (IOException e){}
        }
    }
    
    public static String getResourceMimeType(String fileExt)
    {
        if (Validates.isEmptyBlank(fileExt))
            return _APPLICATION_OCTET_STREAM_;
        
        String mimeType = (String)p.get(fileExt);
        if (mimeType == null)
            return _APPLICATION_OCTET_STREAM_;
        
        return mimeType;
    }
}
