/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd.bio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;

import org.zhiqim.httpd.HttpListener;
import org.zhiqim.httpd.HttpServer;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Sockets;
import org.zhiqim.kernel.util.Threads;
import org.zhiqim.kernel.util.Validates;

/**
 * HTTP阻塞式监听器 
 * 
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class HttpBioListener extends HttpListener
{
    private ServerSocket serverSocket;
    
    public HttpBioListener(HttpServer server)
    {
        super(server);
    }
    
    @Override /** 线程开启前 */
    protected boolean openBefore()
    {
        //监听参数和线程池
        super.openBefore();
        
        try
        {//监听端口和守护线程
            if (Validates.isEmpty(listenerIp))
                serverSocket = new ServerSocket(listenerPort);
            else
                serverSocket = new ServerSocket(listenerPort, 50, InetAddress.getByName(listenerIp));
            serverSocket.setReuseAddress(true);
            return true;
        }
        catch (Exception e)
        {
            throw Asserts.exception(e);
        }
    }

    @Override /** 线程关闭后 */
    protected void closeAfter()
    {
        if (serverSocket != null)
        {//关闭监听
            Threads.closeIgnoreException(serverSocket);
            serverSocket = null;
        }
        
        //关闭父类的控制器/定时任务/连接列表
        super.closeAfter();
    }

    @Override /** 线程持续运行 */
    protected void loop()
    {
        try
        {
            Socket socket = serverSocket.accept();
            Sockets.setOption(socket, true, soTimeoutMs, soLingerS, false);
            
            //连接交给控制器多线程处理
            controller.execute(add(newConnection(socket)));
        }
        catch (SocketException e)
        {
            if (!_SOCKET_CLOSED_.equalsIgnoreCase(e.getMessage()))
            {//非服务端自己关闭连接导致的异常打印
                log.error(toString() + "SocketException异常", e);
            }
        }
        catch (IOException e)
        {
            log.error(toString() + "IO异常", e);
        }
    }
    
    /** 新建连接 */
    private HttpBioConnection newConnection(Socket socket) throws IOException
    {
        return new HttpBioConnection(this, socket, socket.getInputStream(), socket.getOutputStream());
    }
}
