/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd;

import java.io.IOException;

import org.zhiqim.kernel.util.codes.Base64;
import org.zhiqim.kernel.util.codes.SHA1;

/**
 * HttpWebsocket服务
 *
 * @version v1.0.0 @author zouzhigang 2017-6-9 新建与整理
 */
public class HttpWebsocketService implements HttpExecutor
{
    @Override
    public boolean isMatch(String pathInContext)
    {
        return _PATH_SERVICE_WS_.equals(pathInContext);
    }

    @Override
    public void handle(HttpRequest request, HttpResponse response) throws IOException
    {
        if (!request.isWebSocket())
        {//非WS服务不支持
            response.sendError(_403_FORBIDDEN_);
            return;
        }
        
        HttpSession session = request.getSession();
        if (session == null)
        {//必须会话支持
            response.sendError(_403_FORBIDDEN_);
            return;
        }
        
        //1.响应成功
        response.setStatus(_101_SWITCHING_PROTOCOLS_);
        response.setHeader(_CONNECTION_, _UPGRADE_);
        response.setHeader(_UPGRADE_, _WEBSOCKET_);
        
        //2.响应Sec-WebSocket-Accept&Sec-WebSocket-Protocol
        String key = request.getHeader(_SEC_WEBSOCKET_KEY_);
        String accept = Base64.encode(SHA1.encodeByte(key + _WEBSOCKET_SALT_, _UTF_8_C_));
        response.setHeader(_SEC_WEBSOCKET_ACCEPT_, accept);
        
        String protocol = request.getHeader(_SEC_WEBSOCKET_PROTOCOL_, null);
        if (protocol != null)
        {//响应协议
            response.setHeader(_SEC_WEBSOCKET_PROTOCOL_, protocol);
        }
        
        //3.升级连接为WS连接
        HttpConnection conn = ((HttpRequestAbs)request).getConnection();
        conn.doWebsocket(request.getContext(), protocol, session.getId());
    }
}
