/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd;


/**
 * HttpWebsocket接口定义
 *
 * @version v1.0.0 @author zouzhigang 2017-6-9 新建与整理
 */
public interface HttpWebsocket
{
    /**
     * 接收到连接开启
     * 
     * @param conn      消息连接
     */
    public void onOpen(HttpWebsocketConnection conn);
    
    /**
     * 接收连接主动关闭
     * 
     * @param conn      消息连接
     */
    public void onClose(HttpWebsocketConnection conn);
    
    /**
     * 接收异常
     * 
     * @param conn      消息连接
     * @param e         消息异常
     */
    public void onException(HttpWebsocketConnection conn, Throwable e);
    
    /**
     * 接收到文本消息
     * 
     * @param conn      消息连接
     * @param message   消息字符串
     */
    public void onMessage(HttpWebsocketConnection conn, String message);
    
    /**
     * 接收到字节消息
     * 
     * @param conn      消息连接
     * @param message   消息字节数组
     */
    public void onMessage(HttpWebsocketConnection conn, byte[] message);
}
