/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd;

import java.util.List;

import org.zhiqim.kernel.paging.PageResult;

/**
 * HTTP会话管理器接口<br><br>
 * 1.要求实现启动方法<br>
 * 2.设置会话值<br>
 * 3.获取会话值<br>
 * 4.删除会话值<br>
 * 5.遍历会话值
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public interface HttpSessionManager extends HttpdConstants
{
    /** 设置上下文环境对象 */
    public void setContext(HttpContext context);
    
    /** 获取上下文环境对象 */
    public HttpContext getContext();
    
    /******************************************************************************************/
    //开启和关闭
    /******************************************************************************************/
    
    /** 开启会话管理 */
    public void open();
    
    /** 关闭会话管理 */
    public void close();
    
    /******************************************************************************************/
    //设置参数部分
    /******************************************************************************************/
    
    /** 设置会话超时时长 */
    public void setSessionTimeout(int sessionTimeout);
    
    /** 获取会话超时时长 */
    public int getSessionTimeout();

    /** 设置会话编号名称 */
    public void setSessionIdName(String sessionCookieName);
    
    /** 获取会话编号名称 */
    public String getSessionIdName();
    
    /** 设置会话参数 */
    public void setSessionParameter(String sessionParameter);
    
    /******************************************************************************************/
    //设置 & 获取 & 失效 会话
    /******************************************************************************************/
    
    /** 新建会话 */
    public HttpSession newSession(String sessionId);
    
    /** 设置会话 */
    public void setSession(HttpSession session);
    
    /** 获取会话 */
    public HttpSession getSession(String sessionId);
    
    /** 判断会话是否存在 */
    public boolean hasSession(String sessionId);
    
    /** 通过会话编号使会话失效 */
    public void invalidateSession(String sessionId);
    
    /** 更新会话最后访问时间 */
    public void updateLastAccessed(String sessionId);
    
    /** 更新会话信息 */
    public void updateInfo(String sessionId, String sessionIp, String userAgent);
    
    /******************************************************************************************/
    //会话查询和统计
    /******************************************************************************************/
    
    /** 会话数 */
    public int size();
    
    /** 获取会话列表 */
    public List<HttpSession> getSessionList();
    
    /** 获取会话分页信息 */
    public PageResult<HttpSession> getSessionPage(int pageNo, int pageSize);
    
    /******************************************************************************************/
    //会话用户查询和统计
    /******************************************************************************************/
    
    /** 会话登录数 */
    public int sizeUser();
    
    /** 是否有会话名称对应的会话 */
    public boolean hasSessionName(String sessionName);
    
    /** 获取会话登录用户列表，指定会话用户类名（如前后端共用session管理器的情况） */
    public List<HttpSessionUser> getSessionUserList();
    
    /** 获取会话登录用户分页信息，指定会话用户类名（如前后端共用session管理器的情况） */
    public PageResult<HttpSessionUser> getSessionUserPage(int pageNo, int pageSize);
}
