/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd;

import java.io.IOException;
import java.io.OutputStream;

/**
 * HTTP发送器
 *
 * @version v1.0.0 @author zouzhigang 2014-2-27 新建与整理
 */
public interface HttpSender extends HttpdConstants
{
    /** 设置状态 */
    public void setStatus(int code);
    
    /** 设置编码格式 */
    public void setCharacterEncoding(String encoding);
    
    /** 获取响应状态 */
    public int getStatus();
    
    /** 获取响应原因 */
    public String getReason();
    
    /***********************************************************************/
    // 设置头部信息
    /***********************************************************************/
    
    /** 设置头部域 */
    public void setHeader(String key, Object value);
    
    /** 设置头部日期格式域 */
    public void setDateHeader(String key, long value);
    
    /** 设置头部域，增加一个属性 */
    public void addHeader(String key, Object value);
    
    /** 设置头部日期格式域，增加一个日期类型的属性 */
    public void addDateHeader(String key, long value);
    
    /**
     * 设置内容类型，会增加默认的字符集到消息头中
     * 
     * @param contentType       内容类型
     */
    public void setContentType(String contentType);
    
    /**
     * 设置内容类型，不设置字符集到消息头中
     * 
     * @param contentType       内容类型
     */
    public void setContentTypeNoCharset(String contentType);
    
    /***********************************************************************/
    // sendError & sendRedirect
    /***********************************************************************/
    
    /**
     * 发送错误信息
     * 
     * @param code              编码
     * @throws IOException      异常
     */
    public void sendError(int code) throws IOException;
    
    /**
     * 发送错误信息
     * 
     * @param code              编码
     * @param reason            原因
     * @throws IOException      异常
     */
    public void sendError(int code, String reason) throws IOException;
    
    /**
     * 发送错误信息，内容为HTML格式
     * 
     * @param code              响应码
     * @throws IOException      可能的异常
     */
    public void sendErrorHTML(int code) throws IOException;

    /**
     * 发送错误信息，内容为HTML格式
     * 
     * @param code              响应码
     * @param reason            响应原因
     * @throws IOException      可能的异常
     */
    public void sendErrorHTML(int code, String reason) throws IOException;
    
    /**
     * 发送重定向信息
     * 
     * @param location          重定向URL
     * @throws IOException      异常
     */
    public void sendRedirect(String location) throws IOException;
    
    /**
     * 发送消息头，如304等，会清空内容
     * 
     * @param code              响应码，可以是200表示成功
     * @throws IOException      可能的异常
     */
    public void sendHeader(int code) throws IOException;
    
    /**
     * 一般用于返回200-207的成功码和提示的一个内容，和sendError不同的是sendError的reason=content，而sendSuccess的reason=默认值
     *  
     * @param code              成功码
     * @param content           内容
     * @throws IOException      可能的异常
     */
    public void sendContent(int code, String content) throws IOException;
    
    /***********************************************************************/
    // write & print & commit
    /***********************************************************************/
    
    /** 获取输出流 */
    public OutputStream getOutputStream();
    
    /** 写内容字节方式 */
    public void write(byte[] b) throws IOException;
    
    /** 写内容加回车换行 */
    public void println(String str) throws IOException;
    
    /** 写回车换行 */
    public void println() throws IOException;
    
    /** 写内容,无回车换行 */
    public void print(String str) throws IOException;
    
    /** 提交流 */
    public void commit() throws IOException;
}
