/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd;


/**
 * HTTP响应接口定义
 *
 * @version v1.0.0 @author zouzhigang 2016-7-19 新建与整理
 */
public interface HttpResponse extends HttpSender
{
    /***********************************************************************/
    // 关联连接信息
    /***********************************************************************/
    
    /** 获取连接编号 */
    public String getId();
    
    /** 获取当前请求 */
    public HttpRequest getRequest();
    
    /** 获取上下文环境 */
    public HttpContext getContext();
    
    /***********************************************************************/
    // 状态处理和判断
    /***********************************************************************/
    
    /** 是否已提交 */
    public boolean isCommitted();
    
    /** 是否可编辑 */
    public boolean isEditable();
    
    /***********************************************************************/
    // 设置状态或，或重定向，或错误重定向
    /***********************************************************************/
    
    /** 编码URL，增加非useCookie时有可能的jsessionid，在URL跳转时需要 */
    public String encodeURL(String url);
    
    /***********************************************************************/
    // 设置头部信息
    /***********************************************************************/
    
    /** 设置缓存控制域 */
    public void setCacheControl(String value);
    
    /** 设置缓存控制域为私有 */
    public void setCacheControlPrivate();
    
    /** 删除头部域 */
    public void removeHeader(String key);
    
    /** 获取头部域 */
    public String getHeader(String key);
    
    /** 判断是否有头部域 */
    public boolean hasHeader(String key);
    
    /** 获取编码格式 */
    public String getCharacterEncoding();
    
    /***********************************************************************/
    // 设置Cookie
    /***********************************************************************/
    
    /** 增加cookie值，浏览器关闭即失效 */
    public void addCookie(String name, String value);
    
    /** 增加cookie值，指定保存时间 */
    public void addCookie(String name, String value, int seconds);
    
    /** 增加Cookie值 */
    public void addCookie(HttpCookie cookie);
    
    /** 删除Cookie值 */
    public void removeCookie(String name);
    
    /** 清空Cookie */
    public void clearCookie();
}
