/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd;

import org.zhiqim.kernel.control.Configurable;
import org.zhiqim.kernel.extend.HashMapSS;
import org.zhiqim.kernel.logging.Log;

public interface HttpHeader extends HttpdConstants, Configurable
{
    /** 获取日志对象 */
    public Log getLog();
    
    /** 获取对应的HTTP监听器监听端口 */
    public int getListenerPort();
    
    /** 获取发送器 */
    public HttpSender getSender();
    
    /** 获取客户端IP地址 */
    public String getRemoteAddr();
    
    /** 获取请求正在处理的上下文环境 */
    public HttpContext getContext();
    
    /** 获取在上下文环境下的路径 */
    public String getPathInContext();
    
    /** 获取资源文件下绝对路径 */
    public String getPathOnResource();
    
    /***********************************************************************/
    //获取和判断请求行信息，包括协议、方法、版本、URI等
    /***********************************************************************/

    /** 获取请求行 */
    public String getHeaderLine();
    
    /** 获取请求版本 */
    public String getVersion();
    
    /** 获取URI路径,以/开头，如/test.html，如果没有文件后缀则为'/' */
    public String getPath();
    
    /** 获取请求方法 */
    public String getMethod();
    
    /** 是否是HEAD方法 */
    public boolean isMethodHead();
    
    /** 是否是GET方法 */
    public boolean isMethodGet();
    
    /** 是否是POST方法 */
    public boolean isMethodPost();
    
    /** 是否需要响应内容 */
    public boolean isMethodResponseContent();
    
    /** 是否WebSocket */
    public boolean isWebSocket();
    
    /** 获取查询串 */
    public String getQueryString();
    
    /** 获取HOST:PORT */
    public String getHostPort();
    
    /** 如果有PORT只仅HOST */
    public String getHostOnly();
    
    /** 获取浏览器代理 */
    public String getUserAgent();
    
    /** 获取URI虚拟目录信息 */
    public String getVirtualDirectory();
    
    /***********************************************************************/
    //获取和判断请求头部信息
    /***********************************************************************/
    
    /** 获取头部信息 */
    public HashMapSS getHeaders();
    
    /** 获取请求头属性 */
    public String getHeader(String key);
    
    /** 获取请求内容长度 */
    public int getContentLength();

    /** 获取请求内容类型 */
    public String getContentType();
    
    /** 获取请求要求的类型 */
    public String getMimeType();
    
    /** 判断是否表单提交 */
    public boolean isMimeForm();
    
    /** 判断是否文本请求 */
    public boolean isMimeTextPlain();
    
    /** 设置请求的编码格式 */
    public void setCharacterEncoding(String characterEncoding);

    /** 获取请求要求的编码,如果未设置默认UTF-8 */
    public String getCharacterEncoding();
    
    /** 获取请求头中的编码,如果未设置默认null */
    public String getCharacterEncodingHeader();
    
    /** 是否请求内容GZIP */
    public boolean isRequestGZip();
    
    /** 是否响应支持GZIP */
    public boolean isResponseGZip();
}
