/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd;

import java.io.IOException;

/**
 * 定义HTTP业务处理器，和HttpEntity不同的是：
 * 1.创建完善的HttpRequest和HttpResponse用于业务处理
 * 2.支持HttpSession和Validate等业务形态
 * 3.支持view,redirect,forward等业务形态
 *
 * @see HttpEntity  实体处理器
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public interface HttpExecutor extends HttpHandler
{
    /**
     * 处理HTTP请求, 来自GET,POST方法
     * 
     * @param request 请求
     * @param response 响应
     * @throws IOException IO异常
     */
    public void handle(HttpRequest request, HttpResponse response) throws IOException;
}
