/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd;

import java.io.IOException;

import org.zhiqim.httpd.constants.HttpStatus;


/**
 * 定义HTTP级错误，捕捉时直接返回错误信息
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class HttpException extends IOException
{
    private static final long serialVersionUID = 1L;
    
    private int code;

    public int getCode()
    {
        return code;
    }

    public HttpException()
    {
        code = HttpdConstants._400_BAD_REQUEST_;
    }
    
    public HttpException(String message)
    {
        super(message);
        code = HttpdConstants._503_SERVER_UNAVAILABLE_;
    }
    
    public HttpException(int code)
    {
        this.code=code;
    }
    
    public HttpException(int code, String message)
    {
        super(message);
        this.code=code;
    }

    public String getReason()
    {
        return HttpStatus.getStatusMsg(code);
    }
    
    public String toString()
    {
        String message = getMessage();
        String reason = getReason();
        return "HttpException("+code+","+reason+","+message+")";
    }

}

