/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd;

import java.net.URL;
import java.net.URLClassLoader;

/**
 * HTTP 上下文环境的ClassLoader
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class HttpContextLoader extends URLClassLoader
{
    private static final String[] _SYSTEM_CLASSES_ = new String [] {"java.","javax.xml.","org.xml.","org.w3c.","org.zhiqim."};
    
    private ClassLoader _parent;
    
    public HttpContextLoader(ClassLoader parent)
    {
        super(new URL[0], parent);
        this._parent = parent;
    }
    
    public Class<?> loadClass(String name) throws ClassNotFoundException
    {
        return loadClass(name, false);
    }
    
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException
    {
        Class<?> c = findLoadedClass(name);
        if (c != null)
            return c;
        
        ClassNotFoundException ex= null;
        try{c = this.findClass(name);}catch (ClassNotFoundException e){ex = e;}
        
        if (c == null && _parent != null)
            try{c = _parent.loadClass(name);}catch (ClassNotFoundException e){ex = e;}
        
        if (c == null)
            throw ex;

        if (resolve)
            resolveClass(c);

        return c;
    }
    
    public URL getResource(String name)
    {
        URL url = null;
        boolean triedParent = false;
        if (isSystemPath(name))
        {
            triedParent = true;
            url = _parent.getResource(name);
        }
        
        if (url == null)
        {
            url = this.findResource(name);
            if (url == null && name.startsWith("/"))
                url = this.findResource(name.substring(1));
        }
        
        if (url == null && !triedParent)
            url = _parent.getResource(name);
        
        return url;
    }
    
    /** 是否指定为系统路径 */
    public boolean isSystemPath(String name)
    {
        name = name.replace('/','.');
        while(name.startsWith("."))
            name = name.substring(1);

        for (String c : _SYSTEM_CLASSES_)
        {
            if (c.endsWith("."))
            {//类前缀
                if (name.startsWith(c))
                    return true;
            }
            else if (name.equals(c))
            {//类全称
                return true;
            }
        }
        
        return false;
    }
}
