/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 *
 * This file is part of [zhiqim_httpd].
 * 
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.httpd;

import java.io.IOException;
import java.nio.ByteBuffer;

/**
 * HTTP AIO/BIO连接通道接口
 *
 * @version v1.0.0 @author zouzhigang 2018-11-16 新建与整理
 */
public interface HttpChannel
{
    /**
     * 从连接通道中获取缓冲
     * 
     * @param buf           缓冲
     * @return              读取到的数目
     * @throws Exception    异常
     */
    public int read(ByteBuffer buf) throws IOException;
    
    /**
     * 写入缓冲到连接通道中
     * 
     * @param buf           缓冲
     * @return              写入到的数目
     * @throws Exception    异常
     */
    public int write(ByteBuffer buf) throws IOException;
}
