/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.xml.parser;

import java.util.ArrayList;
import java.util.List;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Classes;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.xml.Xml;
import org.zhiqim.kernel.xml.XmlParser;
import org.zhiqim.kernel.xml.Xmls;

/**
 * 数组解析器,8种基本类型数组、字符串数组和对象数组
 *
 * @version v1.1.2 @author zouzhigang 2015-8-21 新建与整理
 */
public class ArrayParser implements XmlParser
{
    private Xml xmlMain;
    
    @Override
    public XmlParser set(Xml xmlMain)
    {
        this.xmlMain = xmlMain;
        return this;
    }
    
    @Override
    public String toStringInner(Object obj, String tagName, int tagLevel)
    {
        StringBuilder strb = new StringBuilder();
        if (tagName != null)
        {//要组号
            Strings.addNewLine(strb);
            Strings.addTwoSpace(strb, tagLevel);
            Xmls.addTagBegin(strb, tagName);
        }
        
        Object[] objs = Arrays.toArray(obj);
        for (Object o : objs)
        {
            strb.append(xmlMain.toStringInner(o, tagName, tagLevel++));
        }
        
        if (tagName != null)
        {//要组号
            Strings.addNewLine(strb);
            Strings.addTwoSpace(strb, tagLevel);
            Xmls.addTagEnd(strb, tagName);
        }
        return strb.toString();
    }

    @Override
    public Object toObjectInner(Node node, Class<?> clazz, Class<?> generics)
    {//数组类型，取组件类型不采用泛型
        if (node == null)
        {//数组如果没有返回null，这里和列表不一样，列表返回空表
            return null;
        }
        
        generics = clazz.getComponentType();
        
        List<Object> list = new ArrayList<Object>(); 
        String tagName = Xmls.getXmlClassTag(generics);
        NodeList childList = node.getChildNodes();
        for (int i=0;i<childList.getLength();i++)
        {
            Node child = childList.item(i);
            if (child.getNodeType() != Node.ELEMENT_NODE)
                continue;
            
            if (!child.getNodeName().equals(tagName))
                continue;
            
            list.add(xmlMain.toObjectInner(child, generics, null));
        }
        
        Object[] arr = Classes.newInstance(generics, list.size());
        for (int i=0;i<arr.length;i++)
        {
            arr[i] = list.get(i);
        }
        
        return arr;
    }
}
